{
   This file is part of VirtualBus.
   Copyright 2002-2004 Marcin Kompanowski, Adam Popioek, Kakish, Maciej Fidor

    VirtualBus is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VirtualBus is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VirtualBus; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}


unit wysw1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, StrUtils,umklogger;

const kostka=8 ;

type
  TTabl = array of array of boolean;
  TLinijka = record
            Tekst : string;
            Typ : byte;
            end;
  TTeksty = array [1..5,1..12] of TLinijka; /// [1..2,1..6]
  TLinia = record
             Numer: string;
             Teksty : TTeksty;
             end;
  TTablica = record
             TypW,TypT : Char;
             Wys,Szer : integer;
             Nazwa : String;
             TypLinie : array [1..6] of char;
             Wyswietlacz : TTabl;
             end;
  TTablice = record
              nazwa, nazwapliku : string;
              end;
  TAutobus = record
              Nazwa,ObrazTabl:String;
              Iltablic : integer;
              Tablice : array of TTablice
              end;
    TWyswietlacze = class(TForm)
    BtnTabl: TButton;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
  function Odstep(typ,tablrodz:Char):integer;
  function Znak(C:Char):integer;
  Function Dekoduj(liczba:integer):string;
  Function Zmiesc(S:String;sz:integer;typ,tablrodz:char):char;
  procedure WstawZnak(C:char;x,y:integer;typ,tablrodz:char;var Tablica:TTabl);
  Procedure ZerujTablice(x,y:integer;var Tablica:TTabl);
  Function Dlugosc(C,typ,tablrodz:Char):integer;
  Procedure WstawTekstSrodek(S:String;x,y,wys,sz:integer;typ,tablrodz:char;var Tabl:TTabl);
  Function WstawTekstLewo(S:String;x,y,wys,sz:integer;typ,tablrodz:char;var Tablica:TTabl):integer;
  Function WstawTekstPrawo(S:String;x,y,wys,sz:integer;typ,tablrodz:char;var Tablica:TTabl):integer;
  Procedure WczytajTablice(nazwa:string);
  Procedure Wczytaj;
  Procedure WczytajLinie(nazwalinii:string);
  Procedure WczytajBusa;
  Function Srodek(i:integer;typ:char):integer;
  procedure KreujTablice(Tbl:TTablice);
    procedure BtnTablClick(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Wyswietlacze: TWyswietlacze;
  Tablica : TTablica;
  Matryca : array[1..5,1..47,1..16] of integer;
  Dykta: array[1..5,1..49,1..2] of integer;
  Bus: TAutobus;
  Linia:Tlinia;
  NazwaLinii:string;
  PunktON,PunktOFF,TablicaGraf:TBitmap;
  kier : integer;


implementation


uses Unit1, Unit2;
{$R *.dfm}

//var    log1:tmklogger;

Procedure TWyswietlacze.ZerujTablice(x,y:integer;var Tablica:TTabl);

var i,j: integer;

begin;
  For i:=1 to x do
    for j:=1 to y do Tablica[i,j]:=false;
  end;

function TWyswietlacze.Odstep(typ,tablrodz:Char):integer;
var ntypu,hlp:integer;
begin;
case typ of
      'a' : begin ntypu:=1; end;
      'b' : begin ntypu:=2; end;
      'c' : begin ntypu:=3; end;
      'd' : begin ntypu:=4; end;
      'e' : begin ntypu:=5; end;
   end;
  hlp:=1;
  if tablrodz<>'m' then hlp:=Dykta[ntypu,48,2] else if typ='a' then hlp:=2;
  odstep:=hlp;
  end;




function TWyswietlacze.Znak(C:Char):integer;
  var hlp:integer;
  begin;
    hlp:=0;
    case c of
      '1' : hlp:=1;
      '2' : hlp:=2;
      '3' : hlp:=3;
      '4' : hlp:=4;
      '5' : hlp:=5;
      '6' : hlp:=6;
      '7' : hlp:=7;
      '8' : hlp:=8;
      '9' : hlp:=9;
      '0' : hlp:=10;
      'a' : hlp:=11;
      '' : hlp:=12;
      'b' : hlp:=13;
      'c' : hlp:=14;
      '' : hlp:=15;
      'd' : hlp:=16;
      'e' : hlp:=17;
      '' : hlp:=18;
      'f' : hlp:=19;
      'g' : hlp:=20;
      'h' : hlp:=21;
      'i' : hlp:=22;
      'j' : hlp:=23;
      'k' : hlp:=24;
      'l' : hlp:=25;
      '' : hlp:=26;
      'm' : hlp:=27;
      'n' : hlp:=28;
      '' : hlp:=29;
      'o' : hlp:=30;
      '' : hlp:=31;
      'p' : hlp:=32;
      'r' : hlp:=33;
      's' : hlp:=34;
      '' : hlp:=35;
      't' : hlp:=36;
      'u' : hlp:=37;
      'v' : hlp:=38;
      'w' : hlp:=39;
      'x' : hlp:=40;
      'y' : hlp:=41;
      'z' : hlp:=42;
      '' : hlp:=43;
      '' : hlp:=44;
      '-' : hlp:=45;
      '.' : hlp:=46;
      '"' : hlp:=47;
      end;
   Znak:=hlp;
  end;

Function TWyswietlacze.Dlugosc(C,typ,tablrodz:Char):integer;

var ntypu,wys,max,i,nznaku: integer;

begin;
  case typ of
      'a' : begin wys:=16; ntypu:=1; end;
      'b' : begin wys:=12; ntypu:=2; end;
      'c' : begin wys:=9; ntypu:=3; end;
      'd' : begin wys:=7; ntypu:=4; end;
      'e' : begin wys:=5; ntypu:=5; end;
   end;
  if C<>' ' then begin
    nznaku:=Znak(C);
    max:=0;
    if tablrodz<>'m' then max:=Dykta[ntypu,nznaku,2] else
      for i:=1 to wys do
        if max<length(dekoduj(Matryca[ntypu,nznaku,i])) then
         max:=length(dekoduj(Matryca[ntypu,nznaku,i]))
    end
    else if tablrodz='m' then max:=2 else max:=Dykta[ntypu,49,2];
    Dlugosc:=max;
  end;

Function TWyswietlacze.Dekoduj(liczba:integer):string;
  var dziel,i : integer;
      s,s2 : string;
begin;
  dziel:=1;
  repeat
    dziel:=dziel*2;
    until liczba<dziel;
  s:='';
  repeat
    dziel:=trunc(dziel/2);
    s:=s+inttostr(trunc(liczba/dziel));
    liczba:=liczba mod dziel;
    until dziel=1;
    s2:=s;
  for i:=1 to length(s) do
    s2[i]:=s[length(s)-i+1];
  Dekoduj:=s2;
end;

Procedure TWyswietlacze.WstawZnak(C:char;x,y:integer;typ,tablrodz:char;var Tablica:TTabl);

var nznaku,i,j:integer;
    ciag : String;
    Zrodlo : TBitmap;
    wys,ntypu:integer;
    Wklejz, WklejDO : TRect;
begin;
  nznaku:=Znak(C);
  case typ of
   'a' : begin wys:=16; ntypu:=1; end;
   'b' : begin wys:=12; ntypu:=2; end;
   'c' : begin wys:=9; ntypu:=3; end;
   'd' : begin wys:=7; ntypu:=4; end;
   'e' : begin wys:=5; ntypu:=5; end;
   end;
  if tablrodz='m' then
    for i:=1 to wys do begin
     Ciag:=dekoduj(Matryca[ntypu,nznaku,i]);
      for j:=1 to length(ciag) do
        if ciag[j]='1' then Tablica[x+j-1,y+i-1]:=true
           else Tablica[x+j-1,y+i-1]:=false
      end
        else begin;
        Zrodlo:=TBitmap.Create;
        y:=(y-1)*kostka+1;
        Zrodlo.LoadFromFile('tab\elementy\dykta'+inttostr(wys)+'.bmp');
        WklejDo:=Rect(x,y,x+Dykta[ntypu,nznaku,2],y+wys*kostka);
        Wklejz:=Rect(Dykta[ntypu,nznaku,1],0,Dykta[ntypu,nznaku,1]+Dykta[ntypu,nznaku,2],wys*kostka);
        TablicaGraf.Canvas.CopyRect(WklejDo,Zrodlo.Canvas,WklejZ);
        Zrodlo.Free;
        end;

end;

Function TWyswietlacze.Zmiesc(S:String;sz:integer;typ,tablrodz:char):char;
var i,dl: integer;
begin;
   case typ of
   'a' : typ:=' ';
   'b' : typ:='a';
   'c' : typ:='b';
   'd' : typ:='c';
   'e' : typ:='d';
   end;
  Repeat
    case typ of
     'a' : typ:='b';
     'b' : typ:='c';
     'c' : typ:='d';
     'd' : typ:='e';
     ' ' : typ:='a';
     end;
    dl:=0;
    if typ<>'f' then
      For i:=1 to length(s) do dl:=dl+dlugosc(s[i],typ,tablrodz);
    dl:=dl+odstep(typ,tablrodz)*(length(s)-1);
    until ((dl<sz) or (typ='e')) or (typ='f');
    if dl>sz then typ:='f';
    Zmiesc:=typ;
end;

Procedure TWyswietlacze.WstawTekstSrodek(S:String;x,y,wys,sz:integer;typ,tablrodz:char;var Tabl:TTabl);

var i,dl:integer;

Begin;
  {if tablrodz<>'m' then sz:=sz*kostka;}
  typ:=Zmiesc(S,sz,typ,tablrodz);
  dl:=0;
    if typ<>'f' then
      For i:=1 to length(s) do dl:=dl+dlugosc(s[i],typ,tablrodz);
    dl:=dl+odstep(typ,tablrodz)*(length(s)-1);
  if (dl<sz) and (typ<>'f') then begin
    y:=y-1+Srodek(wys-y+1,Typ);
    x:=x+Trunc((sz-dl)/2);
    For i:=1 to length(s) do begin;
      if s[i]<>' ' then WstawZnak(S[i],x,y,typ,tablrodz,Tabl);
      x:=x+dlugosc(s[i],typ,tablrodz)+odstep(typ,tablrodz);
      end;
    end;
  end;

Function TWyswietlacze.WstawTekstLewo(S:String;x,y,wys,sz:integer;typ,tablrodz:char;var Tablica:TTabl):integer;
var i:integer;
begin
  typ:=Zmiesc(S,sz,typ,tablrodz);
  if typ<>'f' then
    y:=y-1+Srodek(wys-y+1,Typ);
    For i:=1 to length(s) do begin;
    if s[i]<>' ' then WstawZnak(S[i],x,y,typ,tablrodz,Tablica);
    x:=x+dlugosc(s[i],typ,tablrodz)+odstep(typ,tablrodz);
    end;
  WstawTekstLewo:=x;
  end;

Function TWyswietlacze.WstawTekstPrawo(S:String;x,y,wys,sz:integer;typ,tablrodz:char;var Tablica:TTabl):integer;
var i,dl:integer;
begin
  typ:=Zmiesc(S,sz,typ,tablrodz);
  if typ<>'f' then begin;
    For i:=1 to length(s) do dl:=dl+dlugosc(s[i],typ,tablrodz);
    dl:=dl+odstep(typ,tablrodz)*(length(s));
    dl:=x-dl;
    y:=y-1+Srodek(wys-y+1,Typ);
    x:=dl+1;
    For i:=1 to length(s) do begin;
    if s[i]<>' ' then WstawZnak(S[i],x,y,typ,tablrodz,Tablica);
    x:=x+dlugosc(s[i],typ,tablrodz)+odstep(typ,tablrodz);
    end;
    end;
  WstawTekstPrawo:=dl;
  end;



Procedure ZamienNaGr(sz,wy:integer;Tablica:TTabl;var Graf:TBitmap);
var i,j:integer;
    WklejZ,WklejDo:Trect;
begin;
for i:=1 to sz do
  for j:=1 to wy do begin;
    WklejDo:=Rect((i-1)*kostka,(j-1)*kostka,i*kostka,j*kostka);
    Wklejz:=Rect(0,0,kostka,kostka);
    if Tablica[i,j] then
     Graf.Canvas.CopyRect(WklejDo,PunktOn.Canvas,WklejZ) else
       Graf.Canvas.CopyRect(WklejDo,PunktOff.Canvas,WklejZ);
    end;
  end;



Procedure TWyswietlacze.Wczytaj;

var F:TextFile;
    S,ms:String;
    C:Char;
    k,mat,i,j:integer;

begin;
  For mat:=1 to 5 do begin
   if mat=1 then ms:='16';
   if mat=2 then ms:='12';
   if mat=3 then ms:='9';
   if mat=4 then ms:='7';
   if mat=5 then ms:='5';
   AssignFile(F,'tab\matryce\matryca'+ms+'.csv');
   Reset(F);
   i:=0;
   {For i:=1 to 46 do begin;}
   repeat
    i:=i+1;
     j:=0;
     While not(eoln(F)) do begin;
       j:=j+1;
       S:='';
       Repeat
         Read(F,C);
         if C<>';' then S:=S+C;
         until (C=';') or (eoln(F));
       Matryca[mat,i,j]:=strtoint(S);
       end;
      Readln(F);
      until i=47;
    CloseFile(F);
    end;

  AssignFile(F,'tab\matryce\dykta.csv');
  Reset(F);
  for i:=1 to 49 do begin;
   j:=5;
   k:=0;
   While not(eoln(F)) do begin;
       k:=k+1;
       if k=3 then begin k:=1; j:=j-1; end;
       S:='';
       Repeat
         Read(F,C);
         if C<>';' then S:=S+C;
         until (C=';') or (eoln(F));
       Dykta[j,i,k]:=strtoint(S);
       end;
      Readln(F);
      end;

  PunktOn:=TBitmap.Create;
  PunktOn.LoadFromFile('tab\elementy\'+Bus.ObrazTabl+'off.bmp');
  PunktOff:=TBitmap.Create;
  PunktOff.LoadFromFile('tab\elementy\'+Bus.ObrazTabl[1]+'cloff.bmp');
end;

Procedure TWyswietlacze.WczytajTablice(nazwa:string);

var F:TextFile;
    S:String;
    i: integer;
begin
  AssignFile(F,nazwa);
  Reset(F);
  Readln(F,S);
  Tablica.TypW:=s[1];
  Readln(F,S);
  Tablica.TypT:=s[1];
  Readln(F,S);
  Tablica.Szer:=strtoint(s);
  Readln(F,S);
  Tablica.Wys:=strtoint(s);
  for i:=1 to 6 do begin;
    Readln(F,S);
    Tablica.TypLinie[i]:=S[1];
    end;
  CloseFile(F);
  Setlength(Tablica.Wyswietlacz,Tablica.Szer+1);
  for i:=1 to Tablica.Szer do Setlength(Tablica.Wyswietlacz[i],Tablica.Wys+1);
  ZerujTablice(Tablica.Szer,Tablica.Wys,Tablica.Wyswietlacz);
  end;


Procedure TWyswietlacze.WczytajLinie(nazwalinii:string);

var

    i:integer;

begin;

  Linia.Numer:=AnsiLowerCase(form2.edLinia.Text);
  for i:=1 to 5 do begin


  Linia.Teksty[i,1].Typ:=2;
  Linia.Teksty[i,2].Typ:=7;
  Linia.Teksty[i,3].Typ:=7;
  Linia.Teksty[i,4].Typ:=7;
  Linia.Teksty[i,5].Typ:=7;
  Linia.Teksty[i,6].Typ:=7;

  linia.Teksty[i,1].Tekst:=AnsiLowerCase(form2.tablice[i].linia1);
  linia.Teksty[i,2].Tekst:=AnsiLowerCase(form2.tablice[i].linia2);
  linia.Teksty[i,3].Tekst:=AnsiLowerCase(form2.tablice[i].pkt1);
  linia.Teksty[i,4].Tekst:=AnsiLowerCase(form2.tablice[i].pkt2);
  linia.Teksty[i,5].Tekst:=AnsiLowerCase(form2.tablice[i].pkt3);
  linia.Teksty[i,6].Tekst:=AnsiLowerCase(form2.tablice[i].pkt4);


  if form2.tablice[i].typ=1 then begin;    //'=' OK
    Linia.Teksty[i,1].Typ:=5;
    Linia.Teksty[i,2].Typ:=5;

    end;
  if form2.tablice[i].typ=2  then begin;               //'>' OK
    Linia.Teksty[i,1].Typ:=4;
    Linia.Teksty[i,2].Typ:=6;

    end;
  if form2.tablice[i].typ=3  then begin;

    Linia.Teksty[i,2].Typ:=6;
    Linia.Teksty[i,1].Typ:=4;

    end;


  end;

  end;

Function TWyswietlacze.Srodek(i:integer;typ:char):integer;
var wys,hlp : integer;
begin;
case typ of
   'a' : wys:=16;
   'b' : wys:=12;
   'c' : wys:=9;
   'd' : wys:=7;
   'e' : wys:=5;
   end;
hlp:=trunc((i-wys)/2)+1;
Srodek:=hlp
end;

Procedure TWyswietlacze.WczytajBusa;
var F:TextFile;
    S:String;
    i:integer;
    kat_wysw:String;
begin;
  kat_wysw := ExtractFilePath(ParamStr(0));
  AssignFile(F,kat_wysw+'model\'+form2.combobox2.Items[form2.combobox2.ItemIndex]+'\'+form2.combobox3.Items[form2.combobox3.Itemindex]+'\wysw.bus');
  Reset(F);
  Readln(F,S);
  Bus.Nazwa:=s;
  Readln(F,S);
  Bus.ObrazTabl:=s;
  Readln(F,S);
  Bus.Iltablic:=strtoint(s);
  SetLength(Bus.Tablice,Bus.Iltablic+1);
  for i:=1 to bus.Iltablic do begin;
    Readln(F,S);
    Bus.Tablice[i].nazwa:=s;
    Readln(F,S);
    Bus.Tablice[i].nazwapliku:=s;
    end;
  CloseFile(F);
  end;






procedure TWyswietlacze.KreujTablice(Tbl:TTablice);
var x,wys1linii,TypHlp,szhlp,xhlp,dl,i,l1hlp,l2hlp:integer;
    HlpTekst,linia1,linia2:string;
begin
//log1:=tmklogger.create(extractfiledir(application.exename)+'\wylog.txt');
TablicaGraf:=TBitmap.Create;
//log1.wriln('1');
TablicaGraf.PixelFormat:=pf24bit;
Wczytaj;
WczytajLinie(nazwalinii);
WczytajTablice('tab\tablice\'+Tbl.nazwa+'.tab');
//log.wriln('2');
TablicaGraf.Height:=Tablica.Wys*kostka;
TablicaGraf.Width:=Tablica.Szer*kostka;
x:=1;
//log.wriln('3');
if Tablica.TypW='m' then szhlp:=1 else szhlp:=kostka;
if Tablica.TypT<>'g' then begin
//log.wriln('4');
  if (Tablica.TypT='a') or ((Tablica.TypT='b') or (Tablica.TypT='c')) then
    x:=WstawTekstLewo(Linia.Numer,1,1,Tablica.Wys,Tablica.Szer*szhlp,Tablica.TypLinie[1],Tablica.TypW,Tablica.Wyswietlacz);
  if (Tablica.TypT<>'a') and (Tablica.TypT<>'d') then
  begin
//  log.wriln('5');
  xhlp:=trunc((Tablica.Szer*szhlp-x+1)/3*2);
  linia1:='';
//  if Linia.Teksty[3-kier,1].Typ<6 then linia1:=linia1+Linia.Teksty[3-kier,1].Tekst;
//  if Linia.Teksty[3-kier,2].Typ<6 then
//    if linia1<>'' then linia1:=linia1+' '+Linia.Teksty[3-kier,2].Tekst else
//      linia1:=linia1+Linia.Teksty[3-kier,2].Tekst;
  linia2:='';
  if Linia.Teksty[kier,1].Typ<6 then linia2:=linia2+Linia.Teksty[kier,1].Tekst;
  if Linia.Teksty[kier,2].Typ<6 then
     if linia2<>'' then linia2:=linia2+' '+Linia.Teksty[kier,2].Tekst else
       linia2:=linia2+Linia.Teksty[kier,2].Tekst;
  l1hlp:=WstawTekstLewo(linia1,x,1,trunc(Tablica.Wys/2),xhlp,Tablica.TypLinie[5],Tablica.TypW,Tablica.Wyswietlacz);
  l2hlp:=WstawTekstPrawo(linia2,Tablica.Szer*szhlp,trunc(Tablica.Wys/2)+1,Tablica.Wys,xhlp,Tablica.TypLinie[5],Tablica.TypW,Tablica.Wyswietlacz);
  if (Tablica.TypT='c') or (Tablica.TypT='f') then begin
  linia1:='';
  if Linia.Teksty[kier,3].typ<>7 then linia1:=linia1+Linia.Teksty[kier,3].Tekst;
  if Linia.Teksty[kier,4].typ<>7 then linia1:=linia1+' - '+Linia.Teksty[kier,4].Tekst;
  xhlp:=trunc(xhlp/2);
  For i:=1 to length(linia1) do dl:=dl+dlugosc(linia1[i],Tablica.TypLinie[6],Tablica.TypW);
    dl:=dl+odstep(Tablica.TypLinie[6],Tablica.TypW)*(length(linia1)-1);
  if (dl>xhlp) and (Linia.Teksty[kier,3].typ<>7) then linia1:=Linia.Teksty[kier,3].Tekst;

  linia2:='';
  if Linia.Teksty[kier,5].typ<>7 then linia2:=linia2+Linia.Teksty[kier,5].Tekst;
  if Linia.Teksty[kier,6].typ<>7 then linia2:=linia2+' '+Linia.Teksty[kier,6].Tekst;
  For i:=1 to length(linia2) do dl:=dl+dlugosc(linia2[i],Tablica.TypLinie[6],Tablica.TypW);
    dl:=dl+odstep(Tablica.TypLinie[6],Tablica.TypW)*(length(linia2)-1);
  if (dl>xhlp) and (Linia.Teksty[kier,5].typ<>7) then linia2:=Linia.Teksty[kier,5].Tekst;
  WstawTekstSrodek(linia1,l1hlp,1,trunc(Tablica.Wys/2),(Tablica.Szer*szhlp-l1hlp),Tablica.TypLinie[6],Tablica.TypW,Tablica.Wyswietlacz);
  WstawTekstSrodek(linia2,x,trunc(Tablica.Wys/2)+1,Tablica.Wys,(l2hlp-x),Tablica.TypLinie[6],Tablica.TypW,Tablica.Wyswietlacz);



  end;
  end
  else
  begin;
  if Linia.Teksty[kier,2].Typ=7 then
  WstawTekstSrodek(Linia.Teksty[kier,1].Tekst,x,1,Tablica.Wys,Tablica.Szer-x+1,Tablica.TypLinie[Linia.Teksty[kier,1].Typ],Tablica.TypW,Tablica.Wyswietlacz)
  else begin
  case Tablica.TypLinie[Linia.Teksty[kier,1].Typ] of
   'a' : wys1linii:=16;
   'b' : wys1linii:=12;
   'c' : wys1linii:=9;
   'd' : wys1linii:=7;
   'e' : wys1linii:=5;
   'f' : wys1linii:=-1;
   end;
  If (Tablica.TypLinie[Linia.Teksty[kier,1].Typ]='f') and (Tablica.TypLinie[Linia.Teksty[kier,2].Typ]='f') then begin
    HlpTekst:=Linia.Teksty[kier,1].Tekst+' '+Linia.Teksty[kier,1].Tekst;
    For i:=1 to length(hlptekst) do dl:=dl+dlugosc(hlptekst[i],'e',Tablica.TypW);
    dl:=dl+odstep('e',Tablica.TypW)*(length(hlptekst)-1);
    if dl>(Tablica.Szer*szhlp-x+1) then HlpTekst:=Linia.Teksty[kier,1].Tekst;
    TypHlp:=2;
    wys1linii:=Tablica.Wys;
    end
    else begin;
      HlpTekst:=Linia.Teksty[kier,1].Tekst;
      TypHlp:=Linia.Teksty[kier,1].Typ;
      if Tablica.TypLinie[Linia.Teksty[kier,2].Typ]='f' then wys1linii:=Tablica.Wys;
      end;
  WstawTekstSrodek(HlpTekst,x,1,wys1linii+1,Tablica.Szer*szhlp-x+1,Tablica.TypLinie[TypHlp],Tablica.TypW,Tablica.Wyswietlacz);
  if Tablica.TypLinie[Linia.Teksty[kier,2].Typ]<>'f' then WstawTekstSrodek(Linia.Teksty[kier,2].Tekst,x,wys1linii+2,Tablica.Wys,Tablica.Szer*szhlp-x+1,Tablica.TypLinie[Linia.Teksty[kier,2].Typ],Tablica.TypW,Tablica.Wyswietlacz);
  end
  end
  end
  else WstawTekstSrodek(Linia.Numer,1,1,Tablica.Wys,Tablica.Szer*szhlp,Tablica.TypLinie[1],Tablica.TypW,Tablica.Wyswietlacz);
if Tablica.TypW='m' then ZamienNaGr(Tablica.Szer,Tablica.Wys,Tablica.Wyswietlacz,TablicaGraf);
TablicaGraf.SaveToFile('tab\'+Tbl.nazwapliku+IntToStr(kier)+'.bmp');
TablicaGraf.Free;
//log.wriln('kon');
end;

procedure TWyswietlacze.BtnTablClick(Sender: TObject);
var i:integer;
begin
WczytajBusa;
nazwalinii:='tab\akt.lin';
For i:=1 to Bus.Iltablic do KreujTablice(Bus.Tablice[i]);
Wyswietlacze.hide;
end;

procedure TWyswietlacze.RadioButton1Click(Sender: TObject);
begin
kier:=1;
end;

procedure TWyswietlacze.RadioButton2Click(Sender: TObject);
begin
kier:=2;
end;

procedure TWyswietlacze.FormCreate(Sender: TObject);
begin
RadioButton1.Checked:=True;
kier:=1;
end;

end.

