unit umiasto;



interface

uses umklogger,globjects,glVectorfileobjects,glmesh,gltexture,vectortypes,
vectorgeometry,glmisc,glstate,sysutils,mk_utl,glscene,glutils,vectorlists;

type tmiasto=class
constructor create;
procedure init;
procedure load(_mname:string);
procedure loadsch(_mname:string);
//procedure loadswi(_mname:string);
procedure loadcsv(kx,ky,kz,ka,skx,sky,skz:single; nam:string);
procedure dodajsygn(x,y,z,a:real;t1,t2:integer);
procedure sprawdz_sygn;
function znazwy(mesz:tglfreeform;s:string):integer;
public
baza:tgldummycube;
zaczep,swiatelka:tgldummycube;
log:tmklogger;
ulice:tglfreeform;
ulicesa,trawa,blending:boolean;
matlib,matullib,matlib2,siatamat:tglmateriallibrary;
rozmywanie:boolean;
    ttable:array of record t:tdatetime;
                                   st:smallint;
                                   osi,oso:smallint;
                                   at,dt:tdatetime;
                                   gat:integer;
                                   nazwa:string;
                                   end;
    stops:array  of record x,y,z,ang:real;
                                   name:string;
                                   pro:boolean;
                                   px,py,pa,pw,ph:real;
                                   end;
    stopnr,maxstop:integer;
    rczas:tdatetime;
    czyrozklad:boolean;
    przystanek:integer;
    maxprzy,liczba_sygn:integer;
    matlampy:tglmaterial;
    szybki:tgldummycube;
    p_sta:array[1..4] of record x,y,a:double;end;
end;

implementation

type sygnalizator=record
        st:integer;
        ob:tglplane;
        t2,li:integer;
        end;

var swiatla:array[1..200] of sygnalizator;


function tmiasto.znazwy(mesz:tglfreeform;s:string):integer;
var i,ret:integer;
begin
ret:=-1;
        for i:= 1 to mesz.meshobjects.count-1 do  begin
      //          log.wriln(mesz.meshobjects[i].name);
                if mesz.meshobjects[i].name=s then ret:=i;
                end;
        znazwy:=ret;
end;

procedure tmiasto.dodajsygn(x,y,z,a:real;t1,t2:integer);
begin
        inc(liczba_sygn);
        log.wri('liczba_syg '+inttostr(liczba_sygn));
        swiatla[liczba_sygn].ob:=TGLplane(zaczep.addnewchild(TGLplane));
        swiatla[liczba_sygn].ob.position.x:=x;
        swiatla[liczba_sygn].ob.position.z:=y;
        swiatla[liczba_sygn].ob.position.y:=z;
        swiatla[liczba_sygn].ob.turnangle:=a;
        swiatla[liczba_sygn].t2:=t2;
        swiatla[liczba_sygn].li:=t1;
        swiatla[liczba_sygn].ob.scale.Y:=0.6 ;
        swiatla[liczba_sygn].ob.scale.x:=0.2 ;
        swiatla[liczba_sygn].ob.Material.MaterialLibrary:=matlib2;
        swiatla[liczba_sygn].ob.material.LibMaterialName:='sem1'

end;

procedure tmiasto.sprawdz_sygn;
        var i:integer;

begin
        for i:=1 to liczba_sygn do begin
                with swiatla[i] do begin
                inc(li);
                if li>=10*t2 then li:=0;
                if li<t2 then ob.Material.LibMaterialName:='sem2'; //z-cz
                if (li>=t2) and (li<5*t2) then ob.Material.LibMaterialName:='sem3'; //ziel
                if (li>=5*t2) and (li<6*t2) then ob.Material.LibMaterialName:='sem4'; //z
                if (li>=6*t2) then ob.Material.LibMaterialName:='sem1'; //cz
                end;
        end;
end;



procedure tmiasto.loadcsv(kx,ky,kz,ka,skx,sky,skz:single; nam:string);
var baza1:tgldummycube;
    siata:tglmesh;
    tab_v:array[0..64] of record x,y,z,u,v:single; end;
    tab_f:array[0..64] of record a,b,c:word;  end;
    f:textfile;
    linia:string;
    tryb:byte;
    nov:byte;
    nof:byte;
    t1,t_2,t3,t4:integer;
    t:string;
    col:tcolorvector;


        procedure  dodajv(x,y,z,s,t:single);
        var t1:tvector3f;
             a:ttexpoint;
        begin
                t1[0]:=x;t1[1]:=y;t1[2]:=z;
                a.S:=s;a.T:=t;
                //col[0]:=0.5; col[1]:=0.5; col[2]:=0.5; col[3]:=1;
                //col:=clrNeonBlue;
                siata.Vertices.AddVertex(t1,NullVector,col,a);

             //   memo1.Lines.add(format('%f,%f,%f, -  %f,%f,%f',[x,y,z,col[0],col[1],col[2]]));
                siata.Material.FrontProperties.Ambient.Color:=col;
                siata.Material.FrontProperties.diffuse.Color:=col;
                siata.Material.FrontProperties.Emission.Color:=col;
                siata.Material.FrontProperties.Specular.Color:=col;
               // siata.Material.FrontProperties.

        end;

        procedure  dodajf(a,b,c:word);
        begin
                siata.Mode:=mmTriangles;
                dodajv(tab_v[a].x,tab_v[a].y,tab_v[a].z,tab_v[a].u,tab_v[a].v);
                dodajv(tab_v[b].x,tab_v[b].y,tab_v[b].z,tab_v[b].u,tab_v[b].v);
                dodajv(tab_v[c].x,tab_v[c].y,tab_v[c].z,tab_v[c].u,tab_v[c].v);
        end;

        procedure wypelnij;
        var i:integer;
        begin  if nof>0 then begin
                for i:=0 to nof-1 do dodajf(tab_f[i].a,tab_f[i].b,tab_f[i].c);
                siata.CalcNormals(fwClockWise);
        end;   end;

begin
    nov:=0;
    baza1:=tGLdummycube(baza.addnewchild(TGLdummycube));
    baza1.position.x:=kx;
    baza1.position.y:=ky;
    baza1.position.z:=kz;
    baza1.TurnAngle:=ka;
    baza1.Scale.Z:=skz;
    baza1.Scale.y:=sky;
    baza1.Scale.x:=skx;


    assignfile(f,nam);
    reset(f);

    repeat
        readln(f,linia);
        if copy(linia,1,18)='CreateMeshBuilder,' then begin
                if nov>0 then wypelnij;
                tryb:=1; nov:=0; nof:=0;
                siata:=tglmesh(baza1.addnewchild(tglmesh));
                siata.Vertices.clear;
              //  memo1.Lines.add('-----');
                end;
        if (copy(linia,1,10)='AddVertex,') and (tryb=1) then
                begin

                delete(linia,1,10);
                t:=copy(linia,1,pos(',',linia)-1);
                tab_v[nov].x:=strtofloat(t);

                delete(linia,1,pos(',',linia));
                t:=copy(linia,1,pos(',',linia)-1);
                tab_v[nov].y:=strtofloat(t);

                delete(linia,1,pos(',',linia));
                delete(linia,pos(',',linia),1);
                tab_v[nov].z:=strtofloat(linia);
                inc(nov);

                end;

if (copy(linia,1,8)='AddFace,') and (tryb=1) then
                begin
                delete(linia,1,8);
                t:=copy(linia,1,pos(',',linia)-1);
                t1:=strtoint(t);
                delete(linia,1,pos(',',linia));
                t:=copy(linia,1,pos(',',linia)-1);
                t_2:=strtoint(t);
                delete(linia,1,pos(',',linia));
                t:=copy(linia,1,pos(',',linia)-1);
                t3:=strtoint(t);
                delete(linia,1,pos(',',linia));
                delete(linia,pos(',',linia),1);
                t4:=strtoint(linia);

                tab_f[nof].a:=t1;
                tab_f[nof].b:=t_2;
                tab_f[nof].c:=t3;
                inc(nof);
                tab_f[nof].a:=t1;
                tab_f[nof].b:=t3;
                tab_f[nof].c:=t4;
                inc(nof);
                end;

if (copy(linia,1,9)='AddFace2,') and (tryb=1) then
                begin
                delete(linia,1,9);
                t:=copy(linia,1,pos(',',linia)-1);
                t1:=strtoint(t);
                delete(linia,1,pos(',',linia));
                t:=copy(linia,1,pos(',',linia)-1);
                t_2:=strtoint(t);
                delete(linia,1,pos(',',linia));
                t:=copy(linia,1,pos(',',linia)-1);
                t3:=strtoint(t);
                delete(linia,1,pos(',',linia));
                delete(linia,pos(',',linia),1);
                t4:=strtoint(linia);

                tab_f[nof].a:=t1;
                tab_f[nof].b:=t_2;
                tab_f[nof].c:=t3;
                inc(nof);
                tab_f[nof].a:=t1;
                tab_f[nof].b:=t3;
                tab_f[nof].c:=t4;
                inc(nof);
                end;


if (copy(linia,1,12)='LoadTexture,') and (tryb=1) then
                begin
                delete(linia,1,12);
                while pos(',',linia)>0 do delete(linia,pos(',',linia),1);


                t3:=0;
                t1:=siatamat.Materials.Count-1;
           //     memo1.Lines.add(inttostr(t1));
                //if t1>0 then
                for t_2:=0 to t1 do
                        if siatamat.Materials[t_2].Name=linia then t3:=1;

                if t3=0 then begin
                siatamat.Materials.Add;
                t1:=siatamat.Materials.Count-1;
                siatamat.Materials[t1].name:=linia;
                siatamat.Materials[t1].material.Texture.Disabled:=false;
                siatamat.Materials[t1].material.texture.Image.LoadFromFile(linia);
                end;
                siata.Material.MaterialLibrary:=siatamat;
                siata.Material.Texture.Disabled:=false;
                siata.material.LibMaterialName:=linia;

                end;

if (copy(linia,1,22)='SetTextureCoordinates,') and (tryb=1) then
                begin
                delete(linia,1,22);


                t:=copy(linia,1,pos(',',linia)-1);
                t1:=strtoint(t);

                delete(linia,1,pos(',',linia));
                t:=copy(linia,1,pos(',',linia)-1);
                tab_v[t1].u:=strtofloat(t);

                delete(linia,1,pos(',',linia));
                delete(linia,pos(',',linia),1);
                tab_v[t1].v:=strtofloat(linia);

                end;
if (copy(linia,1,9)='SetColor,') and (tryb=1) then
                begin
                delete(linia,1,9);

                t:=copy(linia,1,pos(',',linia)-1);
                col[0]:=strtofloat(t)/64;
                delete(linia,1,pos(',',linia));
                t:=copy(linia,1,pos(',',linia)-1);
                col[1]:=strtofloat(t)/64;
                delete(linia,1,pos(',',linia));
                delete(linia,pos(',',linia),length(linia)-pos(',',linia)+1);
                col[2]:=strtofloat(linia)/64;


                siata.Material.MaterialLibrary:=nil;
                end;


    until eof(f);
    wypelnij;
    closefile(f);
end;



constructor tmiasto.create;
begin
        trawa:=false;
        blending:=false;
        liczba_sygn:=0;
        rozmywanie:=false;
end;

procedure tmiasto.init;
begin
        matlib:=tglmateriallibrary.Create(nil);
        matlib2:=tglmateriallibrary.Create(nil);
        matullib:=tglmateriallibrary.Create(nil);        
        matlib2.Materials.Add;

with matlib2.Materials[0] do begin
        Material.texture.image.loadfromfile('bmps\trawa.bmp');
        Name:='trawa';
        material.texture.disabled:=false;
end;

matlib2.Materials.Add;
with matlib2.Materials[1] do begin
        Material.texture.image.loadfromfile('bmps\sem1.bmp');
        Name:='sem1';
        material.texture.disabled:=false;
end;

matlib2.Materials.Add;
with matlib2.Materials[2] do begin
        Material.texture.image.loadfromfile('bmps\sem2.bmp');
        Name:='sem2';
        material.texture.disabled:=false;
end;

matlib2.Materials.Add;
with matlib2.Materials[3] do begin
        Material.texture.image.loadfromfile('bmps\sem3.bmp');
        Name:='sem3';
        material.texture.disabled:=false;
end;

matlib2.Materials.Add;
with matlib2.Materials[4] do begin
        Material.texture.image.loadfromfile('bmps\sem4.bmp');
        Name:='sem4';
        material.texture.disabled:=false;
end;


zaczep:=tgldummycube.Create(baza);
{swiatelka:=tgldummycube.Create(baza);}
zaczep.Parent:=baza;
end;

procedure tmiasto.load(_mname:string);
var f:textfile;
l,s,fname,plik,kat,cdir,proxyname:string;
typ,linnr,mi,mj,i,j:integer;
maxz,maxx,minz,minx:integer;
kwadrat1:tglplane;
cokolwiek:tglfreeform;
k:real;
proxy,proxy2:tglproxyobject;
prpoz:boolean;
t1,t2,t3,t4,t7,t8,t9:real;
t5,t6:integer;
spr:tglsprite;
lampy:tgldummycube;
szyba:tglfreeform;
szybam:tglmaterial;
kolorszyby:tglcolor;
lObj:TMeshObject;
tri1, n1 : TAffineVectorList;
begin
kolorszyby:=tglcolor.Create(nil);
kolorszyby.SetColor(0.5,0.5,0.5,0.5);
szybam:=tglmaterial.Create(nil);
szybam.BlendingMode:=bmtransparency;
szybam.FrontProperties.Diffuse:=kolorszyby;
ulicesa:=false;
log.wri('open map\'+_mname);
        assignfile(f,'map\'+_mname);
//        form1.caption:=unit2.Form2.plik;
        reset(f);
log.wriln('...ok');
        lampy:=tgldummycube.create(swiatelka.addnewchild(TGLdummycube));
        readln(f,l);inc(linnr);
        typ:=strtoint(l);
        readln(f,l);inc(linnr);
        s:=copy(l,1,pos(',',l)-1);
        mi:=strtoint(s);
        delete(l,1,pos(',',l));
        mj:=strtoint(l);
        maxx:=15;
        minz:=-15;
        matlampy:=tglmaterial.Create(nil);
        matlampy.texture.disabled:=false;
        try
        matlampy.Texture.Image.LoadFromFile('bmps\lampa1.bmp');
        except
        on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
        end;
        matlampy.texture.MinFilter:=miNearest;
        matlampy.texture.MagFilter:=maNearest;
        matlampy.BlendingMode:= bmadditive;
{           if trawa then
           log.wriln('trawa');
                for i:= 0 to 24 do
                for j:=0 to 12 do begin ///
                kwadrat1:=TGLplane(zaczep.addnewchild(TGLplane));
                kwadrat1.position.z:=i*((maxz+minz) div 30);
                kwadrat1.position.y:=-0.05;
                kwadrat1.position.x:=j*((maxx+minx) div 30);
                kwadrat1.Height:=(maxz-minz) div 30//-0.5;
                kwadrat1.Width:=(maxx-minx) div 30//-0.5;
                kwadrat1.Direction.y:=1;
                kwadrat1.Direction.X:=0;
                kwadrat1.direction.z:=0;
                kwadrat1.material.FrontProperties.emission.Color:=clrdarkgreen;
                kwadrat1.material.FrontProperties.ambient.Color:=clrdarkgreen;
                kwadrat1.material.FrontProperties.diffuse.Color:=clrdarkgreen;
                kwadrat1.Material.MaterialLibrary:=matlib;
                kwadrat1.Material.LibMaterialName:='trawa';
        end;
}
        repeat
                readln(f,l);inc(linnr);
                log.wri('map\'+_mname+'['+inttostr(linnr)+']:'+l );


                if copy(l,1,2)='L1' then begin
                         fname:='scene\lampa.3ds';
                         delete(l,1,3);
                         s:=fname;
                         plik:=getcurrentdir+'\'+s;
                         kat:='scene';
                         cdir:=getcurrentdir;
//////////////// kulka
                         if  blending then begin
                                try
                                spr:=TGLsprite(lampy.addnewchild(TGLsprite));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                 k:=strtofloat(paramnr(l,3))*pi/180;
                                spr.Position.x:=-strtofloat(paramnr(l,0))+15+2.5*cos(k);
                                spr.position.z:=strtofloat(paramnr(l,1))-15-2.5*sin(k);
                                spr.position.y:=11.5;
                                spr.scale.x:=1;
                                spr.scale.y:=1;
                                spr.scale.z:=1;
                                spr.material:=matlampy;

                            //    if blending then kwadrat1.Material.Texture.Imagebrightness:=0.2;
                           //     kwadrat1.material.texture.ImageAlpha:=tiaTopLeftPointColorTransparent;
                 //               kwadrat1.material.texture.TextureMode:=tmreplace;

                                spr.NoZWrite:=true;

////////////////  plama

                                try
                                kwadrat1:=TGLPlane(lampy.addnewchild(TGLPlane));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                 k:=strtofloat(paramnr(l,3))*pi/180;
                                 log.wriln('bvb'+floattostr(k));
                                kwadrat1.Position.x:=-strtofloat(paramnr(l,0))+15+7*cos(k);
                                kwadrat1.position.z:=strtofloat(paramnr(l,1))-15-7*sin(k);
                                kwadrat1.position.y:=0.1;
                                kwadrat1.scale.x:=22;
                                kwadrat1.scale.y:=22;
                                kwadrat1.scale.z:=15;
                                kwadrat1.pitchangle:=90;
                                log.wriln(format('%f %f',[kwadrat1.Position.x,kwadrat1.Position.z]));
                                kwadrat1.material:=matlampy;
                        end;
//////////////////  slup
                         setcurrentdir(kat);
                         if fname<>proxyname then begin
                                try
                                cokolwiek:=TGLFreeForm(zaczep.addnewchild(TGLFreeForm));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                cokolwiek.MaterialLibrary:=matlib;
                                cokolwiek.UseMeshMaterials:=true;
                                try;
                                cokolwiek.loadfromfile(plik);
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                end;
                                cokolwiek.position.x:=-strtofloat(paramnr(l,0))+15;
                                cokolwiek.position.z:=strtofloat(paramnr(l,1))-15;
                                k:=strtofloat(paramnr(l,2));
                                cokolwiek.up.y:=1;
                                cokolwiek.up.x:=0;
                                cokolwiek.up.z:=0;
                                cokolwiek.direction.y:=1;
                                cokolwiek.direction.z:=0;
                                cokolwiek.direction.x:=0;
                                cokolwiek.rollangle:=k;
                                proxyname:=fname;

                                log.wriln(floattostr(-strtofloat(paramnr(l,1))+15));
                                log.wriln(floattostr(strtofloat(paramnr(l,2))-15));

                         end else begin
                                 try
                                proxy:=TGLProxyObject(zaczep.addnewchild(TGLProxyObject));
                                 except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                proxy.MasterObject:=cokolwiek;
                                proxy.ProxyOptions:=[pooObjects];
                                proxy.position.x:=-strtofloat(paramnr(l,0))+15;
                                proxy.position.z:=strtofloat(paramnr(l,1))-15;
                                k:=strtofloat(paramnr(l,2));
                                proxy.up.y:=1;
                                proxy.up.x:=0;
                                proxy.up.z:=0;
                                proxy.direction.y:=1;
                                proxy.direction.z:=0;
                                proxy.direction.x:=0;
                                proxy.rollangle:=k;
                         end;
                         setcurrentdir(cdir);
                        l:='';
                end;

                if copy(l,1,2)='M1' then begin
                         fname:=l;
                         delete(fname,1,pos('"',fname));
                         delete(l,1,3);
                         fname:=copy(fname,1,pos('"',fname)-1);
                         s:=fname;
                         plik:=getcurrentdir+'\'+s;
                         kat:='';
                         while pos('\',plik)<>0 do begin
                                kat:=kat+copy(plik,1,pos('\',plik));
                                delete(plik,1,pos('\',plik));
                         end;
                         cdir:=getcurrentdir;
                         setcurrentdir(kat);
                         if fname<>proxyname then begin
                                try
                                cokolwiek:=TGLFreeForm(zaczep.addnewchild(TGLFreeForm));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                cokolwiek.MaterialLibrary:=matlib;
                                cokolwiek.UseMeshMaterials:=true;
                                try;
                                cokolwiek.loadfromfile(plik);
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                end;
                                cokolwiek.position.x:=-strtofloat(paramnr(l,0))+15;
                                cokolwiek.position.z:=strtofloat(paramnr(l,1))-15;
                                cokolwiek.position.y:=strtofloat(paramnr(l,2));
                                k:=strtofloat(paramnr(l,3));
                                cokolwiek.scale.x:=strtofloat(paramnr(l,4));
                                cokolwiek.scale.y:=strtofloat(paramnr(l,5));
                                cokolwiek.scale.z:=strtofloat(paramnr(l,6));
                                cokolwiek.up.y:=1;
                                cokolwiek.up.x:=0;
                                cokolwiek.up.z:=0;
                                cokolwiek.direction.y:=1;
                                cokolwiek.direction.z:=0;
                                cokolwiek.direction.x:=0;
                                cokolwiek.rollangle:=k;
                                proxyname:=fname;
                         end else begin
                                 try
                                proxy:=TGLProxyObject(zaczep.addnewchild(TGLProxyObject));
                                 except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                proxy.MasterObject:=cokolwiek;
                                proxy.ProxyOptions:=[pooObjects];
                                proxy.position.x:=-strtofloat(paramnr(l,0))+15;
                                proxy.position.z:=strtofloat(paramnr(l,1))-15;
                                proxy.position.y:=strtofloat(paramnr(l,2));
                                k:=strtofloat(paramnr(l,3));
                                proxy.scale.x:=strtofloat(paramnr(l,4));
                                proxy.scale.y:=strtofloat(paramnr(l,5));
                                proxy.scale.z:=strtofloat(paramnr(l,6));
                                proxy.up.y:=1;
                                proxy.up.x:=0;
                                proxy.up.z:=0;
                                proxy.direction.y:=1;
                                proxy.direction.z:=0;
                                proxy.direction.x:=0;
                                proxy.rollangle:=k;
                         end;
                         setcurrentdir(cdir);
                        l:='';
                end;
                if copy(l,1,2)='M3' then begin
                                        log.wriln('jest m3');
                         fname:=l;
                         delete(fname,1,pos('"',fname));
                         delete(l,1,3);
                         fname:=copy(fname,1,pos('"',fname)-1);
                         s:=fname;
                         plik:=getcurrentdir+'\'+s;
                         kat:='';
                         while pos('\',plik)<>0 do begin
                                kat:=kat+copy(plik,1,pos('\',plik));
                                delete(plik,1,pos('\',plik));
                         end;
                         cdir:=getcurrentdir;
                         setcurrentdir(kat);

                                try
                                cokolwiek:=TGLFreeForm(zaczep.addnewchild(TGLFreeForm));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                cokolwiek.MaterialLibrary:=matlib;
                                cokolwiek.UseMeshMaterials:=true;
                                try;
                                cokolwiek.loadfromfile(plik);
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                end;




                                cokolwiek.position.x:=-strtofloat(paramnr(l,0))+15;
                                cokolwiek.position.z:=strtofloat(paramnr(l,1))-15;
                                cokolwiek.position.y:=strtofloat(paramnr(l,2));
                                k:=strtofloat(paramnr(l,3));
                                cokolwiek.scale.x:=strtofloat(paramnr(l,4));
                                cokolwiek.scale.y:=strtofloat(paramnr(l,5));
                                cokolwiek.scale.z:=strtofloat(paramnr(l,6));
                                cokolwiek.up.y:=1;
                                cokolwiek.up.x:=0;
                                cokolwiek.up.z:=0;
                                cokolwiek.direction.y:=1;
                                cokolwiek.direction.z:=0;
                                cokolwiek.direction.x:=0;
                                cokolwiek.rollangle:=k;
                                if (znazwy(cokolwiek,'b_1')>=0) then begin
                                //        log.wriln('jest b_2');
                                        szyba:=tglfreeform.Create(cokolwiek.addnewchild(TGLFreeForm)); szyba.parent:=szybki;
                                        szyba.Material:=szybam;
                                        lObj := TMeshObject.CreateOwned(szyba.MeshObjects);
                                        tri1   := TAffineVectorList.create;
                                        n1   := TAffineVectorList.create;
                                        lObj.Vertices := cokolwiek.MeshObjects[znazwy(cokolwiek,'b_1')].ExtractTriangles(tri1,n1);
                                        lobj.Normals:=n1;
                                        lobj.TexCoords:=tri1;
                                        cokolwiek.MeshObjects[znazwy(cokolwiek,'b_1')].Free;
                                        szyba.position:=cokolwiek.Position;
                                        szyba.scale:=cokolwiek.scale;
                                        szyba.Up:=cokolwiek.up;
                                        szyba.direction:=cokolwiek.direction;
                                      //  szyba.rollangle:=cokolwiek.rollangle;
                                end;
                                setcurrentdir(cdir);
                        l:='';
                end;

                if (copy(l,1,2)='U1') and (not ulicesa) then begin
                        delete(l,1,3);
                        try
                        ulice:=TGLFreeForm(zaczep.addnewchild(TGLFreeForm));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                        ulice.MaterialLibrary:=matullib;
                        ulice.UseMeshMaterials:=true;
                        ulice.position.x:=-strtofloat(paramnr(l,0))+15;
                        ulice.position.z:=strtofloat(paramnr(l,1))-15;
                        ulice.position.y:=strtofloat(paramnr(l,2));
                        k:=strtofloat(paramnr(l,3));
                        ulice.scale.x:=strtofloat(paramnr(l,4));
                        ulice.scale.y:=strtofloat(paramnr(l,5));
                        ulice.scale.z:=strtofloat(paramnr(l,6));
                        delete(l,1,pos(#34,l));
                        s:=copy(l,1,pos(#34,l)-1);
                        plik:=getcurrentdir+'\'+s;
                        kat:='';
                        while pos('\',plik)<>0 do begin
                                kat:=kat+copy(plik,1,pos('\',plik));
                                delete(plik,1,pos('\',plik));
                        end;
                        cdir:=getcurrentdir;
                        setcurrentdir(kat);
                        try
                        ulice.loadfromfile(plik);
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                        setcurrentdir(cdir);
                        ulice.up.y:=1;
                        ulice.up.x:=0;
                        ulice.up.z:=0;
                        ulice.direction.y:=1;
                        ulice.direction.z:=0;
                        ulice.direction.x:=0;
                        ulice.rollangle:=k+180;
                        ulicesa:=true;
                        l:='';
                end;
                if (copy(l,1,2)='ST') then begin
                        delete(l,1,3) ;
                        stopnr:=strtoint(paramnr(l,0));
                        if stopnr>maxstop then begin
                                maxstop:=stopnr;
                                SetLength(stops, maxstop+1);
                        end;
                        stops[stopnr].x:=strtofloat(paramnr(l,1))-15;
                        stops[stopnr].y:=strtofloat(paramnr(l,2))-15;
                        stops[stopnr].z:=strtofloat(paramnr(l,3));
                        stops[stopnr].ang:=strtofloat(paramnr(l,4));
                        stops[stopnr].pro:=false;
                        if stops[stopnr].ang<0.1 then stops[stopnr].ang:=7;
                        delete(l,1,pos('"',l));
                        s:=copy(l,1,pos('"',l)-1);
                        stops[stopnr].name:=s;
                        l:='';
                end;
                if (copy(l,1,2)='SP') then begin
                        delete(l,1,3);
                        stopnr:=strtoint(paramnr(l,0));
                        stops[stopnr].px:=strtofloat(paramnr(l,1))-15;
                        stops[stopnr].py:=strtofloat(paramnr(l,2))-15;
                        stops[stopnr].pa:=strtofloat(paramnr(l,3));
                        stops[stopnr].pw:=strtofloat(paramnr(l,4));
                        stops[stopnr].ph:=strtofloat(paramnr(l,5));
                        stops[stopnr].pro:=true;
                        l:='';
                end;
                if (copy(l,1,2)='P2') or (copy(l,1,2)='P3')then begin
                         if copy(l,1,2)='P3' then prpoz:=true else prpoz:=false;
                         fname:=l;
                         delete(fname,1,pos('"',fname));
                         delete(l,1,3);
                         fname:=copy(fname,1,pos('"',fname)-1);
                         s:=fname;
                         plik:=getcurrentdir+'\'+s;
                         kat:='';
                         while pos('\',plik)<>0 do begin
                                kat:=kat+copy(plik,1,pos('\',plik));
                                delete(plik,1,pos('\',plik));
                         end;
                         cdir:=getcurrentdir;
                         setcurrentdir(kat);
                         if fname<>proxyname then begin
                                try
                                kwadrat1:=TGLPlane(zaczep.addnewchild(TGLPlane));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                kwadrat1.Position.x:=-strtofloat(paramnr(l,0))+15;
                                kwadrat1.position.z:=strtofloat(paramnr(l,1))-15;
                                kwadrat1.position.y:=strtofloat(paramnr(l,2));
                                kwadrat1.turnangle:=strtofloat(paramnr(l,3));
                                if prpoz then kwadrat1.pitchAngle:=90;
                                kwadrat1.scale.x:=strtofloat(paramnr(l,4));
                                kwadrat1.scale.y:=strtofloat(paramnr(l,5));
                                if not prpoz then kwadrat1.position.Y:=kwadrat1.position.Y+kwadrat1.scale.y/2;
                                kwadrat1.material.texture.disabled:=false;
                                try
                                kwadrat1.Material.Texture.Image.LoadFromFile(cdir+'\'+fname);
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                if blending then kwadrat1.Material.Texture.Imagebrightness:=0.2;
                                kwadrat1.material.texture.ImageAlpha:=tiaTopLeftPointColorTransparent;
                                kwadrat1.material.texture.TextureMode:=tmreplace;
                                kwadrat1.Material.texture.MinFilter:=miNearest;
                                kwadrat1.Material.texture.MagFilter:=maNearest;
                                kwadrat1.Material.BlendingMode:= bmTransparency;
                                if not prpoz then begin
                                proxy2:=TGLProxyObject(zaczep.addnewchild(TGLProxyObject));
                                proxy2.MasterObject:=kwadrat1;
                                proxy2.ProxyOptions:=[pooObjects];
                                proxy2.Turnangle:=kwadrat1.turnangle+180;
                                proxy2.scale.x:=kwadrat1.scale.x;
                                proxy2.scale.y:=kwadrat1.scale.y;
                                proxy2.position.x:=kwadrat1.position.x;
                                proxy2.position.y:=kwadrat1.position.y;
                                proxy2.position.z:=kwadrat1.position.z;
                                end;
                                proxyname:=fname;
                         end else begin
                                try
                                proxy:=TGLProxyObject(zaczep.addnewchild(TGLProxyObject));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                proxy.MasterObject:=kwadrat1;
                                proxy.ProxyOptions:=[pooObjects];
                                proxy.position.x:=-strtofloat(paramnr(l,0))+15;
                                proxy.position.z:=strtofloat(paramnr(l,1))-15;
                                proxy.position.y:=strtofloat(paramnr(l,2));
                                proxy.turnangle:=strtofloat(paramnr(l,3));
                                if prpoz then proxy.pitchAngle:=90;
                                proxy.scale.x:=strtofloat(paramnr(l,4));
                                proxy.scale.y:=strtofloat(paramnr(l,5));
                                if not prpoz then begin
                                proxy.position.Y:=proxy.position.Y+proxy.scale.y/2;
                                proxy2:=TGLProxyObject(zaczep.addnewchild(TGLProxyObject));
                                proxy2.MasterObject:=proxy;
                                proxy2.ProxyOptions:=[pooObjects];
                                proxy2.Turnangle:=proxy.turnangle+180;
                                proxy2.scale.x:=proxy.scale.x;
                                proxy2.scale.y:=proxy.scale.y;
                                proxy2.position.x:=proxy.position.x;
                                proxy2.position.y:=proxy.position.y;
                                proxy2.position.z:=proxy.position.z;
                                end;
                        end;
                setcurrentdir(cdir);
                        l:='';
                end;

                if (copy(l,1,2)='SE') then begin
                        delete(l,1,3);
                        t1:=-strtofloat(paramnr(l,0))+15;
                        t2:=strtofloat(paramnr(l,1))-15;
                        t3:=strtofloat(paramnr(l,2));
                        t4:=strtofloat(paramnr(l,3));
                        t5:=strtoint(paramnr(l,4));
                        t6:=strtoint(paramnr(l,5));
                       dodajsygn(t1,t2,t3,t4,t5,t6);
                        l:='';
                end;

                if (copy(l,1,2)='B2') or (copy(l,1,2)='B3') then begin
                         if copy(l,1,2)='B3' then prpoz:=true else prpoz:=false;
                        fname:=l;
                        delete(fname,1,pos('"',fname));
                        delete(l,1,3);
                        fname:=copy(fname,1,pos('"',fname)-1);
                        s:=fname;
                        plik:=getcurrentdir+'\'+s;
                        kat:='';
                        while pos('\',plik)<>0 do begin
                                kat:=kat+copy(plik,1,pos('\',plik));
                                delete(plik,1,pos('\',plik));
                        end;
                        cdir:=getcurrentdir;
                        setcurrentdir(kat);
                        if fname<>proxyname then begin
                                try
                                kwadrat1:=TGLPlane(zaczep.addnewchild(TGLPlane));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                kwadrat1.Position.x:=-strtofloat(paramnr(l,0))+15;
                                kwadrat1.position.z:=strtofloat(paramnr(l,1))-15;
                                kwadrat1.position.y:=strtofloat(paramnr(l,2));
                                kwadrat1.turnangle:=strtofloat(paramnr(l,3));
                                if prpoz then kwadrat1.pitchAngle:=90;
                                kwadrat1.scale.x:=strtofloat(paramnr(l,4));
                                kwadrat1.scale.y:=strtofloat(paramnr(l,5));
                                if not prpoz then kwadrat1.position.Y:=kwadrat1.position.Y+kwadrat1.scale.y/2;
                                kwadrat1.material.texture.disabled:=false;
                                try
                                kwadrat1.Material.Texture.Image.LoadFromFile(cdir+'\'+fname);
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                if blending then kwadrat1.Material.Texture.Imagebrightness:=0.2;
                                kwadrat1.Material.texture.MinFilter:=miNearest;
                                kwadrat1.Material.texture.MagFilter:=maNearest;
                                try
                                proxy2:=TGLProxyObject(zaczep.addnewchild(TGLProxyObject));
                                                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                 if not prpoz then begin
                                proxy2.MasterObject:=kwadrat1;
                                proxy2.ProxyOptions:=[pooObjects];
                                proxy2.Turnangle:=kwadrat1.turnangle+180;
                                proxy2.scale.x:=kwadrat1.scale.x;
                                proxy2.scale.y:=kwadrat1.scale.y;
                                proxy2.position.x:=kwadrat1.position.x;
                                proxy2.position.y:=kwadrat1.position.y;
                                proxy2.position.z:=kwadrat1.position.z;
                                end;
                                proxyname:=fname;

                        end else begin
                                try
                                proxy:=TGLProxyObject(zaczep.addnewchild(TGLProxyObject));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                proxy.MasterObject:=kwadrat1;
                                proxy.ProxyOptions:=[pooObjects];
                                proxy.position.x:=-strtofloat(paramnr(l,0))+15;
                                proxy.position.z:=strtofloat(paramnr(l,1))-15;
                                proxy.position.y:=strtofloat(paramnr(l,2));
                                proxy.turnangle:=strtofloat(paramnr(l,3));
                                if prpoz then proxy.pitchAngle:=90;
                                proxy.scale.x:=strtofloat(paramnr(l,4));
                                proxy.scale.y:=strtofloat(paramnr(l,5));

                                try
                                proxy2:=TGLProxyObject(zaczep.addnewchild(TGLProxyObject));
                                except
                                 on e: exception do log.wriln('cla- '+e.ClassName+' -WYJ- '+e.Message);
                                 end;
                                 if not prpoz then begin
                                proxy.position.Y:=proxy.position.Y+proxy.scale.y/2;
                                proxy2.MasterObject:=proxy;
                                proxy2.ProxyOptions:=[pooObjects];
                                proxy2.Turnangle:=proxy.turnangle+180;
                                proxy2.scale.x:=proxy.scale.x;
                                proxy2.scale.y:=proxy.scale.y;
                                proxy2.position.x:=proxy.position.x;
                                proxy2.position.y:=proxy.position.y;
                                proxy2.position.z:=proxy.position.z;
                                end;
                        end;
                setcurrentdir(cdir);
                        l:='';
                end;
                if copy(l,1,2)='M2' then begin
                        fname:=l;
                        delete(fname,1,pos('"',fname));
                        fname:=copy(fname,1,pos('"',fname)-1);
                        delete(l,1,3);
                        s:=fname;
                        plik:=getcurrentdir+'\'+s;
                        kat:='';
                        while pos('\',plik)<>0 do begin
                                kat:=kat+copy(plik,1,pos('\',plik));
                                delete(plik,1,pos('\',plik));
                        end;
                        cdir:=getcurrentdir;
                        setcurrentdir(kat);
                        t1:=-strtofloat(paramnr(l,0))+15;
                        t2:=strtofloat(paramnr(l,1))-15;
                        t3:=strtofloat(paramnr(l,2));
                        t4:=strtofloat(paramnr(l,3));
                        t7:=strtofloat(paramnr(l,4));
                        t8:=strtofloat(paramnr(l,5));
                        t9:=strtofloat(paramnr(l,6));
                        loadcsv(t1,t3,t2,t4,t7,t9,t8,cdir+'\'+fname);
                        setcurrentdir(cdir);
                        l:='';
                end;
log.wriln('..ok');
until eof(f);
closefile(f);
log.wriln('file closed');
lampy.Parent:=swiatelka;

if not rozmywanie then begin
  for i:=0 to matlib.Materials.count-1 do begin
   matlib.Materials[i].Material.texture.magfilter:=maNearest;
   matlib.Materials[i].Material.texture.minfilter:=miNearest;
   end;
  for i:=0 to matlib2.Materials.count-1 do begin
   matlib2.Materials[i].Material.texture.minfilter:=miNearest;
   matlib2.Materials[i].Material.texture.magfilter:=maNearest;
end;
 for i:=0 to matullib.Materials.count-1 do begin
   matullib.Materials[i].Material.texture.magfilter:=maNearest;
  end;
  end;

 for i:=0 to matullib.Materials.count-1 do begin
   matullib.Materials[i].Material.texture.minfilter:=miNearest;
 end;


end;




procedure tmiasto.loadsch(_mname:string);
var f:textfile;
l,s:string;
i,linnr:integer;

begin

linnr:=0;
log.wri('open map\'+_mname);
        assignfile(f,'map\'+_mname);
//        form1.caption:=unit2.Form2.plik;
        reset(f);
        log.wriln('...ok');
        readln(f,l);inc(linnr);
        repeat
                readln(f,l);inc(linnr);
                log.wri('map\'+_mname+'['+inttostr(linnr)+']:'+l );
                if (length(l)>2) and (l[1]='A') and (l[2]>'0') and (l[2]<'5') then begin
                         i:=ord(l[2])-ord('0');
                         delete(l,1,3);
                         p_sta[i].x:=-strtofloat(paramnr(l,0))+15;
                         p_sta[i].y:=strtofloat(paramnr(l,1))-15;
                         p_sta[i].a:=strtofloat(paramnr(l,2));
                         log.wriln(format('A %d %f %f %f',[i,p_sta[i].x,p_sta[i].y,p_sta[i].a]));
                        l:='';
                end;
                if (copy(l,1,2)='RB') then begin
                        delete(l,1,pos(' ',l));
                        rczas:=time-strtotime(l);
                        czyrozklad:=true;
                        przystanek:=1;
                        l:='';
                        end;
                if (copy(l,1,2)='RE') then begin
                        czyrozklad:=false;
                        maxprzy:=przystanek-1;
                        l:='';
                        end;
                if (copy(l,1,2)='RS') and czyrozklad then begin
                        delete(l,1,pos(' ',l));
                        s:=copy(l,1,pos(',',l)-1);
                        SetLength(ttable, przystanek+1);
                        ttable[przystanek].st:=strtoint(s);
                        ttable[przystanek].nazwa:=stops[strtoint(s)].name;
                        delete(l,1,pos(',',l));
                        s:=copy(l,1,pos(',',l)-1);
                        ttable[przystanek].t:=strtotime(s);
                        delete(l,1,pos(',',l));
                        s:=copy(l,1,pos(',',l)-1);
                        if s[1]<>'-' then
                                ttable[przystanek].oso:=round(strtoint(s)/2+random(strtoint(s)))
                                else
                                ttable[przystanek].oso:=strtoint(s);
                        delete(l,1,pos(',',l));
                        ttable[przystanek].osi:=round(strtoint(l)/2+random(strtoint(l)));
                        inc(przystanek);
                        l:='';                        
                end;
log.wriln('..ok');
until eof(f);
closefile(f);
log.wriln('file closed');
end;


end.
