{
   This file is part of VirtualBus.
   Copyright 2002-2004 Marcin Kompanowski, Adam Popioek, Kakish, Maciej Fidor

    VirtualBus is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VirtualBus is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VirtualBus; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit mk_naped;

interface

uses umklogger,sysutils;

type tnaped=class
        private
       //  g_rpm:single;

         xg:array[-1..8] of single;
         vb:array[0..8] of single;

         Fdrive:single;
         n:single;


         function Tengine_f(rpm_p:single):single;
        public
         xd:single;
         cbraking:single;
        p_curve:array[1..4] of record r,t,a:single; end;
        Tengine:single;
        rpm:single;
        throttle:single;
        v:single;
        Rw:single;
        nbieg:integer;
        bieg,liczbabiegow:smallint;
         a,F,M:single;
         wrr:single;
         brake:single;
         Fbrake:single;
         Frr:single;
         automat:boolean;
      {   v2,v3,v4,v5:real;}
         log:tmklogger;
         dziala:boolean;
        procedure licz(dt:single);
        procedure ustaw;
        procedure wczytajskrzynie(a:string);
        procedure wczytajsilnik(a:string);
        procedure policzautomat;
        procedure gup;
        procedure gdn;
        constructor create; overload;
        end;



implementation
uses math;

function tnaped.Tengine_f(rpm_p:single):single;
begin
        if (rpm_p>=p_curve[1].r*0.99) and (rpm_p<p_curve[2].r) then Tengine_f:=(p_curve[1].t+p_curve[1].a*(rpm_p-p_curve[1].r))*throttle;
        if (rpm_p>=p_curve[2].r) and (rpm_p<p_curve[3].r) then Tengine_f:=(p_curve[2].t+p_curve[2].a*(rpm_p-p_curve[2].r))*throttle;
        if (rpm_p>=p_curve[3].r) and (rpm_p<p_curve[4].r) then Tengine_f:=(p_curve[3].t+p_curve[3].a*(rpm_p-p_curve[3].r))*throttle;
        if (rpm_p<p_curve[1].r) or (rpm_p>=p_curve[4].r) then Tengine_f:=0;


end;

procedure tnaped.licz(dt:single);
var ftraction:single;
t_rpm:real;
i:integer;
begin
        //Fdrive=Tengine * xg * xd * n / Rw
        wrr:=(v/Rw);

        if dziala then begin
                        t_rpm :=wrr * xg[bieg] * xd * 30/PI;
                        rpm:=(rpm*3+t_rpm)/4;

                        if rpm<p_curve[1].r then begin
                                rpm:=p_curve[1].r;
                        end;
                end else begin
                        rpm:=rpm*0.75;
                end;

        Tengine:=Tengine_f(rpm);
      //  tengine:=400;
        if bieg<>0 then
        Fdrive:=Tengine * xg[bieg] *xd * n /Rw
        else
        Fdrive:=0;

        ftraction:=fdrive;
        Fbrake:=brake*cbraking;
        if (bieg*v<0) then Fbrake:=0;
        if v=0 then Fbrake:=0;

        F:= Ftraction-sign(v)*(Fbrake + Frr); {Fdrag; }

        a:=F/M;

        v:=v+a*dt;
        if (bieg>0) and (v<0) then v:=0;
        if (bieg<0) and (v>0) then v:=0;
        if (v<0.1) and (v>-0.1) and (brake>0) then v:=0;
        nbieg:=bieg;
        if automat then begin
                if (v>0) then nbieg:=1;
                for i:=2 to liczbabiegow do if (v>vb[i]) then nbieg:=i;
            //    log.wriln(format('%f %f',[v,vb[bieg]]));
                if nbieg<>bieg then begin bieg:=nbieg; {log.wriln('autom '+inttostr(bieg));     }end;
        end;

//        if not dziala then rpm:=rpm*;
end;

procedure tnaped.ustaw;
begin

end;

constructor tnaped.create;
begin
inherited;
        log:=tmklogger.create('d_log.txt');
{        log.czysc;}

                //solaris urbino 15, ZF 5 HP 500
        xd:=6.2;        //przelozenie glowne
        xg[-1]:=-4.84;
        xg[0]:=0;
        xg[1]:=3.43;
        xg[2]:=2.01;
        xg[3]:=1.42;
        xg[4]:=1.0;
        xg[5]:=0.83;
        xg[6]:=0; //brak
        liczbabiegow:=5;
        automat:=false;
        dziala:=false;
        n:=0.7;
        v:=0;
        m:=25000;
        rpm:=0;
        bieg:=0;
        nbieg:=bieg;
        Frr:=2000;


        Rw:=0.45;
        cbraking:=50000;
        p_curve[1].t:=870;
        p_curve[1].r:=1000;

        p_curve[2].t:=1100;
        p_curve[2].r:=1400;

        p_curve[3].t:=1100;
        p_curve[3].r:=1700;

        p_curve[4].t:=825;
        p_curve[4].r:=2400;
        //policz
        p_curve[1].a:=(p_curve[2].t-p_curve[1].t)/(p_curve[2].r-p_curve[1].r);
        p_curve[2].a:=(p_curve[3].t-p_curve[2].t)/(p_curve[3].r-p_curve[2].r);
        p_curve[3].a:=(p_curve[4].t-p_curve[3].t)/(p_curve[4].r-p_curve[3].r);

        policzautomat;
end;

procedure tnaped.policzautomat;
var i:integer;
begin
//        wrr:=(v/Rw); -> v:=wrr*Rw
//        rpm := wrr * xg[bieg] * xd * 30/PI;
//        wrr:=rpm/(xg[bieg]*xd*30/PI);
//              czyli
//        v:=rpm/(xg[bieg] * xd * 30/PI)*Rw;

 {
v2:=(p_curve[4].r/(xg[1] * xd * 30/PI)*Rw)+(p_curve[1].r/(xg[2] * xd * 30/PI)*Rw);
v2:=v2*0.5;
        log.wriln('*'+floattostr(v2)); }
{
v3:=(p_curve[4].r/(xg[2] * xd * 30/PI)*Rw)+(p_curve[1].r/(xg[3] * xd * 30/PI)*Rw);
v3:=v3*0.5;

v4:=(p_curve[4].r/(xg[3] * xd * 30/PI)*Rw)+(p_curve[1].r/(xg[4] * xd * 30/PI)*Rw);
v4:=v4*0.5;

v5:=(p_curve[4].r/(xg[4] * xd * 30/PI)*Rw)+(p_curve[1].r/(xg[5] * xd * 30/PI)*Rw);
v5:=v5*0.5;
}

for i:=2 to liczbabiegow do begin
        vb[i]:=((p_curve[4].r/(xg[i-1] * xd * 30/PI)*Rw)+(p_curve[1].r/(xg[i] * xd * 30/PI)*Rw))*0.5;
 //       log.wriln(floattostr(vb[i]));
end;

end;

procedure tnaped.wczytajskrzynie(a:string);
var f:textfile;
l:string;
i:integer;
begin
        assign(f,'dtrain\'+a);
        reset(f);
        readln(f,l);
        readln(f,liczbabiegow);
        readln(f,xg[-1]);
        for i:=1 to liczbabiegow do
                readln(f,xg[i]);
        closefile(f);

        policzautomat;
end;

procedure tnaped.wczytajsilnik(a:string);
var f:textfile;
l:string;
i:integer;
begin
        assign(f,'dtrain\'+a);
        reset(f);
        readln(f,l);
        readln(f,l);
        for i:=1 to 4 do
                readln(f,p_curve[i].r,p_curve[i].t);
        closefile(f);
        p_curve[1].a:=(p_curve[2].t-p_curve[1].t)/(p_curve[2].r-p_curve[1].r);
        p_curve[2].a:=(p_curve[3].t-p_curve[2].t)/(p_curve[3].r-p_curve[2].r);
        p_curve[3].a:=(p_curve[4].t-p_curve[3].t)/(p_curve[4].r-p_curve[3].r);

        policzautomat;
end;

procedure tnaped.gup;
begin

if bieg<liczbabiegow then inc(bieg);
{log.wriln('manual-U '+inttostr(bieg));}
end;

procedure tnaped.gdn;
begin
if bieg>-1 then dec(bieg);
{log.wriln('manual-D '+inttostr(bieg));}
end;

end.
