{
   This file is part of VirtualBus.
   Copyright 2002-2004 Marcin Kompanowski, Adam Popioek, Kakish,
   Maciej Fidor, Qbasob.

    VirtualBus is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    VirtualBus is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with VirtualBus; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}



unit Unit1;

{$DEFINE MK_DE1B}
{.$DEFINE JOY}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, GLScene, GLObjects, GLWin32Viewer, GLMisc, GLTexture,math,
  StdCtrls, GLSkydome, ComCtrls, ExtCtrls, GLCadencer, GLExtrusion,
  GLVectorFileObjects,Bass, Grids,glfileobj,OpenGL1x, GLHUDObjects,tga,
  GLGeomObjects,vectorgeometry, GLFile3DS,glutils, GLCollision,glmesh,vectortypes,
  glstate,mk_utl,{mk_naped,} GLBitmapFont, GLWindowsFont,umklogger, Joystick, GLSkyBox,jpeg,
  ubusz,umiasto,idexception,uttory,uttr,pojezdy,uobywatele,
  GLWin32FullScreenViewer;

  //karol
  //geometry -> vectorgeometry
  //opengl12 -> opengl1x

  //Fido:
  //U mnie trzeba byo dopisac jeszcze GLFile3DS

type
  TForm1 = class(TForm)
    GLScene1: TGLScene;
    DummyCube1: TGLDummyCube;
    GLCamera1: TGLCamera;
    GLCamera3: TGLCamera;
    srsw: TGLDummyCube;
    GLCadencer1: TGLCadencer;
    Timer1: TTimer;
    GLCamera4: TGLCamera;
    GLLightSource1: TGLLightSource;
    GLMaterialLibrary2: TGLMaterialLibrary;
    GLCamera5: TGLCamera;
    GLMaterialLibrary3: TGLMaterialLibrary;
    srs: TGLDummyCube;
    DirectOpenGL1: TGLDirectOpenGL;
    GLMaterialLibrary1: TGLMaterialLibrary;
    lustrolewe: TGLCamera;
    lustroprawe: TGLCamera;
    GLPlane1: TGLPlane;
    GLHUDSprite1: TGLHUDSprite;
    dr_1: TGLHUDSprite;
    dr_2: TGLHUDSprite;
    dr_3: TGLHUDSprite;
    dr_4: TGLHUDSprite;
    sk1: TGLHUDSprite;
    sk3: TGLHUDSprite;
    Timer2: TTimer;
    siatamat: TGLMaterialLibrary;
    sk9: TGLHUDSprite;
    sterownik: TGLHUDSprite;
    kier1: TGLHUDSprite;
    kier2: TGLHUDSprite;
    wygas: TGLHUDSprite;
    wlacz: TGLHUDSprite;
    Timer3: TTimer;
    Timer4: TTimer;
    wysw_ster_text: TGLHUDText;
    GLWindowsBitmapFont1: TGLWindowsBitmapFont;
    wysw_ster_text_2: TGLHUDText;
    wysw_ster_zegar: TGLHUDText;
    hud_ki: TGLHUDSprite;
    hud_mi: TGLHUDSprite;
    r_bieg: TGLHUDSprite;
    bus_text: TGLHUDText;
    GLWindowsBitmapFont2: TGLWindowsBitmapFont;
    bus_liczba_1: TGLHUDText;
    bus_liczba_2: TGLHUDText;
    przystanek_text: TGLHUDText;
    przystanek_liczba: TGLHUDText;
    podklad_napisy: TGLHUDSprite;
    wysw_ster_text_3: TGLHUDText;
    wysw_ster_text_4: TGLHUDText;
    wysw_ster_text_5: TGLHUDText;
    wysw_ster_text_6: TGLHUDText;
    eng: TGLHUDSprite;
    enmatlib: TGLMaterialLibrary;
    HUDtlo: TGLHUDSprite;

    Joystick1: TJoystick;
    skyboxmatlib: TGLMaterialLibrary;
    GLSkyDome1: TGLSkyDome;
    tuskybox: TGLDummyCube;
    nettimer: TTimer;
    swiatelka: TGLDummyCube;
    szybki: TGLDummyCube;
    GLWindowsBitmapFont3: TGLWindowsBitmapFont;
    hud_bieg: TGLHUDText;
    trawa_1: TGLPlane;
    trawa: TGLDummyCube;
    hud_servermsg: TGLHUDText;
    trbaza: TGLDummyCube;
    cam_d_l: TGLCamera;
    cam_d_r: TGLCamera;
    cam_l_l: TGLCamera;
    cam_l_r: TGLCamera;
    hud_dist: TGLHUDText;
    hud_przykl: TGLHUDSprite;
    GLFullScreenViewer1: TGLFullScreenViewer;



  // procedure loadcsv(kx,ky,kz,ka,skx,sky,skz:single; nam:string);

    procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
    procedure HandleKeys(const deltaTime: Double);
{    procedure Timer1Timer(Sender: TObject);  }
    procedure FormCreate(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);

    procedure GLCadencer1Progress(Sender: TObject; const deltaTime,
      newTime: Double);
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure startuj;
    procedure zamykaj;
    procedure DirectOpenGL1Render(var rci: TRenderContextInfo);
    procedure Timer2Timer(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure Timer4Timer(Sender: TObject);
    procedure mp3play(nr:integer);
    procedure mp3stop;
    procedure mp3scan;
    procedure nettimerTimer(Sender: TObject);
    procedure rusztrawe;
    procedure skaluj;
    procedure n_przystanek;
    procedure GLFullScreenViewer1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GLFullScreenViewer1MouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure GLFullScreenViewer1MouseWheel(Sender: TObject;
      Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
      var Handled: Boolean);
    procedure GLFullScreenViewer1Close(Sender: TObject;
      var Action: TCloseAction);

  private
    { Private declarations }
  public
    { Public declarations }
     mx, my : Integer;

    wewn:boolean;


    kat_wysw : string;


    maxx,maxz,minx,minz:integer;

    pasa:tobywatele;

//   przystanek:integer;
//   maxprzy:integer;
   dz,d0,d1,d2,d3,d4,p0,p1,p2,p3,p4,p5,p6,p7,p8,p10,p11,p12,pdk,ddk:boolean;
   sams: array[1..8] of HSAMPLE;
   ss:array[1..8] of HCHANNEL;
   sh:HCHANNEL ;
//   _delta:real;


   stmp3play:HSTREAM;
   mp3stat,mp3cur,mp3max:integer;
   mp3list:array[1..100] of string;
   mp3fun:integer;

   nop:word;
   nastopie:boolean;
   cznast:real;
   oso,osi:smallint;
   onop:smallint;
   alphatest:boolean;
   maks:boolean;
   postoj:boolean;
   tkier:real;
   ldrz:byte;
   k_flar:array[1..8] of record x,y,z:real; end;
   k_on:boolean;

   ster,wlacz_ster,wylacz_ster,ster_or:integer;

    log:tmklogger;

    joybu:array[1..4] of tjoystickbutton;
    kiernawysw:integer;
    klaw:array[1..60] of integer;
//    drz:array[0..7] of tdrzwi;
    bus:array[1..4] of tbusz;
    miasto:tmiasto;
    traffic:tpoje;
    dzx,dzy:integer;
  end;



var   Form1: TForm1;

implementation

{$R *.dfm}

uses Keyboard,unit2, Unit3, wysw1;

var MAXBUS:integer;
//liczba_sygn:integer;
var licznik_t:word;

pczas,stime:tdatetime;
pau,pauk:boolean;
mojnumer:integer;
servertime:tdatetime;
//wsk_rpm:real;

l_camera:tglcamera;
acam_dl,acam_dr,acam_ll,acam_lr:boolean;


procedure tform1.n_przystanek;

begin

  if (miasto.przystanek<miasto.maxprzy)  then begin

           miasto.ttable[miasto.przystanek].oso:=oso;
           miasto.ttable[miasto.przystanek].osi:=osi;
           nop:=onop;
                       inc(miasto.przystanek) ;
                        wysw_ster_text_4.text:=miasto.ttable[miasto.przystanek].nazwa+' ('+timetostr(miasto.ttable[miasto.przystanek].t)+')';
                        if (miasto.przystanek<miasto.maxprzy) then
                        wysw_ster_text_3.text:=miasto.ttable[miasto.przystanek+1].nazwa
                        else
                        wysw_ster_text_3.text:='******';
if form2.CheckBox19.Checked then begin
  if miasto.stops[miasto.ttable[miasto.przystanek].st].pro then
        begin
                pasa.przy.Position.x:=-miasto.stops[miasto.ttable[miasto.przystanek].st].px;
                pasa.przy.Position.z:=miasto.stops[miasto.ttable[miasto.przystanek].st].py;
                pasa.przy.turnangle:=miasto.stops[miasto.ttable[miasto.przystanek].st].pa;
                pasa.zalosujP(miasto.stops[miasto.ttable[miasto.przystanek].st].pw,
                        miasto.stops[miasto.ttable[miasto.przystanek].st].ph);

        end else
        begin
                pasa.przy.Position.x:=-miasto.stops[miasto.ttable[miasto.przystanek].st].x;
                pasa.przy.Position.z:=miasto.stops[miasto.ttable[miasto.przystanek].st].y;
                pasa.radius:=miasto.stops[miasto.ttable[miasto.przystanek].st].ang;
                pasa.zalosuj;

        end;



                        pasa.vis:=miasto.ttable[miasto.przystanek].osi;
                        pasa.pokaz;
//                        log.wriln('nastepny');

                        end;
                        end;
//log.wriln('cad25');
    postoj:=false;
    if miasto.ttable[miasto.przystanek].oso>=0 then
    miasto.ttable[miasto.przystanek].oso:=min(miasto.ttable[miasto.przystanek].oso,nop) else
    begin
    if miasto.ttable[miasto.przystanek].oso=-1 then miasto.ttable[miasto.przystanek].oso:=nop;
    if miasto.ttable[miasto.przystanek].oso=-2 then postoj:=true;
    end;
    przystanek_liczba.Text:=inttostr(miasto.ttable[miasto.przystanek].osi);
    bus_liczba_2.Text:=inttostr(miasto.ttable[miasto.przystanek].oso);
    bus_liczba_1.Text:=inttostr(trunc(nop));
    if postoj then begin
    przystanek_liczba.Text:='X';
    bus_liczba_2.Text:='X';
    end;



end;


procedure zdekoduj(s:string);
var px,py,a:float;
i:integer;
begin
if s[1]='P' then begin
      //  form1.Caption:=s;
//        form1.log.wriln('rec '+s);
        delete(s,1,2);
//        form1.log.wriln('!'+s);
        for i:=1 to MAXBUS do begin
        delete(s,1,2);
//        form1.log.wriln('!'+s);
        px:=strtofloat(copy(s,1,pos('_',s)-1));
        delete(s,1,pos('_',s));
//        form1.log.wriln('!'+s);
        py:=strtofloat(copy(s,1,pos('_',s)-1));
        delete(s,1,pos('_',s));
//        form1.log.wriln('!'+s);
        a:=strtofloat(copy(s,1,pos('_',s)-1));
        delete(s,1,pos('_',s));
   //     form1.log.wriln('!'+s);
//        form1.log.wriln(format('%d %f %f %f',[i,px,py,a]));
        if i<>mojnumer then
                begin

                form1.bus[i].weka.x:=px;
                form1.bus[i].weka.y:=py;
                form1.bus[i].weka.ang:=a*pi/180.0;
                end;
        end;
end;
end;

procedure getinfo;
var
t:tmemorystream;
s:string;
begin
 if form2.connected then begin
        t:=tmemorystream.Create;
        t.SetSize(512);
        t.Position:=0;
        s:='O';
        t.write(s[1],length(s));
        form2.IdUDPClient1.SendBuffer(t.memory^,t.size);
 end;
end;

procedure sendrecv;
var ReceivedString:string;
t:tmemorystream;
f:double;
i,int:integer;
s:string;
b:boolean;
begin

t:=tmemorystream.Create;
t.SetSize(512);
t.Position:=0;
s:='P';
i:=length(s);
t.write(s[1],i);
i:=sizeof(integer);
t.write(mojnumer,i);


f:=form1.bus[mojnumer].weka.x;
i:=sizeof(double);
t.Writebuffer(f,i);
f:=form1.bus[mojnumer].weka.y;t.Writebuffer(f,i);
f:=form1.bus[mojnumer].weka.ang;t.Writebuffer(f,i);
f:=form1.bus[mojnumer].wekb.x;t.Writebuffer(f,i);
f:=form1.bus[mojnumer].wekb.y;t.Writebuffer(f,i);
f:=form1.bus[mojnumer].wekb.ang;t.Writebuffer(f,i);
b:=form1.bus[mojnumer].plama_p.visible;t.WriteBuffer(b,sizeof(boolean));
i:=form1.bus[mojnumer].kierunek;t.WriteBuffer(i,sizeof(integer));
b:=form1.bus[mojnumer].stop;t.WriteBuffer(b,sizeof(boolean));

{
                i:=sizeof(i);
                t.Writebuffer(i,i);
                i:=sizeof(real);
}
//form1.log.wriln('snd '+format('p %d_%.2f_%.2f_%.2f',[mojnumer,form1.bus[mojnumer].posx,form1.bus[mojnumer].posy,form1.bus[mojnumer].dir]));
//form2.IdUDPClient1.send(format('p %d_%.2f_%.2f_%.2f',[mojnumer,form1.bus[mojnumer].posx,form1.bus[mojnumer].posy,form1.bus[mojnumer].dir]));
   try
form2.IdUDPClient1.SendBuffer(t.memory^,t.size);
//form1.log.wriln('snd '+inttostr(t.size));

if (form2.IdUDPClient1.ReceiveBuffer(t.memory^,t.size))>0 then
begin
        setlength(s,1);
        t.Position:=0;
       t.ReadBuffer(pointer(s)^,1);
       if (s='P') then begin
                t.readbuffer(servertime,sizeof(servertime));
                for i:=1 to 4 do
                        if i<>mojnumer then begin
                        t.ReadBuffer(form1.bus[i].weka.x,sizeof(double));
                        t.ReadBuffer(form1.bus[i].weka.y,sizeof(double));
                        t.ReadBuffer(form1.bus[i].weka.ang,sizeof(double));
                        t.ReadBuffer(form1.bus[i].wekb.x,sizeof(double));
                        t.ReadBuffer(form1.bus[i].wekb.y,sizeof(double));
                        t.ReadBuffer(form1.bus[i].wekb.ang,sizeof(double));
                        t.readbuffer(b,sizeof(boolean)); if (b<>form1.bus[i].plama_p.Visible) then form1.bus[i].swiatla;
                        t.readbuffer(int,sizeof(integer)); form1.bus[i].kierunek:=int;
                        t.ReadBuffer(b,sizeof(boolean)); form1.bus[i].stop:=b;

                        end else begin
                        t.ReadBuffer(f,sizeof(double));
                        t.ReadBuffer(f,sizeof(double));
                        t.ReadBuffer(f,sizeof(double));
                        t.ReadBuffer(f,sizeof(double));
                        t.ReadBuffer(f,sizeof(double));
                        t.ReadBuffer(f,sizeof(double));
                        t.readbuffer(b,sizeof(boolean));
                        t.readbuffer(int,sizeof(integer));
                        t.ReadBuffer(b,sizeof(boolean));
                        end;

       end;
  if (s='I') then begin
        form1.hud_servermsg.text:='server stopped';
        form2.connected:=false;
  end;
  if (s='T') then begin
        t.ReadBuffer(i,sizeof(i));
        setlength(s,i);
        t.readbuffer(pointer(s)^,i);
        form1.hud_servermsg.text:=s;
  end;
       // form1.log.wriln('RECV '+s);
end;
{ReceivedString := form2.IdUDPClient1.ReceiveString();


  if ReceivedString <> '' then
          zdekoduj(ReceivedString);}
          except
          on eidsocketerror do form2.connected:=false;
          end;
t.Destroy;

end;

procedure tform1.rusztrawe;
begin
trawa.absolutePosition:=glfullscreenviewer1.Camera.absolutePosition;
trawa.Position.y:=-0.2;
trawa.Position.x:=(round(trawa.Position.x) div 50) *50;
trawa.Position.z:=(round(trawa.Position.z) div 50) *50;

//log.wriln(format('%f %f %f',[trawa.Position.x,trawa.Position.y,trawa.Position.z]));
end;

procedure tform1.mp3stop;
begin
bass_channelstop(stmp3play);
bass_streamfree(stmp3play);
wysw_ster_text_6.Text:='STOP';
wysw_ster_text_5.Text:='';
end;






procedure tform1.mp3play(nr:integer);
var min,sec:integer;
len:float;
begin
if BASS_ACTIVE_PLAYING=BASS_ChannelIsActive(stmp3play) then mp3stop;
stmp3play:=BASS_StreamCreateFile(FALSE,pchar(form2.mp3dir+mp3list[nr]),0,0,0);
BASS_streamplay(stmp3play,false,0);
mp3cur:=nr;
wysw_ster_text_6.Text:=mp3list[mp3cur];

len:=BASS_ChannelBytes2Seconds(stmp3play,BASS_StreamGetLength(stmp3play));
min:=round(len) div 60;
sec:=round(len) mod 60;
wysw_ster_text_5.Text:=format('%d/%d - [ %d:%.2d ]',[mp3cur,mp3max,min,sec]);
end;

procedure tform1.mp3scan;
var i:integer;
sr: TSearchRec;
begin
i:=1;
FindFirst(form2.mp3dir+'*.mp3',faanyfile, sr);
repeat
        mp3list[i]:=sr.Name;
        inc(i);
until (FindNext(sr) <> 0) or (i>99);
mp3list[i]:='@@@';
mp3max:=i-1;
end;







procedure zapisz(tekst:string);
var a:textfile;
begin
assignfile(a,'c:\vbus-debug.txt');
append(a);
writeln(a,tekst);
close(a);
end;



procedure TForm1.FormMouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);

begin
GLCamera1.AdjustDistanceToTarget(Power(1.1, WheelDelta/120));
 if Glcamera1.Position.y>-2 then glcamera1.position.y:=-2;

end;



procedure TForm1.HandleKeys(const deltaTime: Double);
var skrent:real;

    fl:real;
    iloop:integer;
    moznaotwierac:boolean;
begin
//log.wriln('hk01');
bus[mojnumer].stop:=false;
//if form1.Active then begin
 if IsKeyDown(VK_ESCAPE) and form2.checkbox10.checked then
 begin
 DeleteFile(kat_wysw+'tab\akt.lin');
 DeleteFile(kat_wysw+'tab\przod1.bmp');
 DeleteFile(kat_wysw+'tab\bok1.bmp');
 DeleteFile(kat_wysw+'tab\tyl1.bmp');
 DeleteFile(kat_wysw+'tab\przod2.bmp');
 DeleteFile(kat_wysw+'tab\bok2.bmp');
 DeleteFile(kat_wysw+'tab\tyl2.bmp');
 form2.odlacz;
 glfullscreenviewer1.Active:=false;

 zamykaj;
// Close;
 end;
//log.wriln('hk02');

if not pau then begin //*poczatek sprawdzania czy nie pauza
//log.wriln('hk03');
// sk1.Rotation:=130-17*pred;            //dla 17 ,50km/h jest v=6.5
 sk1.Rotation:=130-8*bus[mojnumer].naped.v;

// wsk_rpm:=(3*wsk_rpm+bus[mojnumer].naped.rpm)/4;
 sk9.Rotation:=100-bus[mojnumer].naped.rpm*0.07;

 if bus[mojnumer].naped.v<0 then  sk1.Rotation:=130;

//log.wriln('hk04');
   skrent:=0;
   //accel:=0;

/////////////////CZESC joystickowa

if form2.checkbox13.checked then begin
        bus[mojnumer].naped.throttle:=0;
        bus[mojnumer].naped.brake:=0;


   if (joystick1.YPosition<-dzy) and ((not dz) or (not bus[mojnumer].blokhamulca)) and (bus[mojnumer].opusz=0) then begin
        bus[mojnumer].naped.throttle:=(-joystick1.YPosition-dzy)/100;
        end;

   if (joystick1.YPosition>dzy) then begin
        bus[mojnumer].naped.brake:=(joystick1.YPosition-dzy)/100;
        end;

   if (joystick1.YPosition>dzy) or (dz and bus[mojnumer].blokhamulca) then begin
        bus[mojnumer].stop:=true;
   end
   else begin
        bus[mojnumer].stop:=false;
   end;

   bus[mojnumer].kierownica:=0;
   if (Joystick1.XPosition<-dzx) then  bus[mojnumer].kierownica:=(Joystick1.XPosition+dzx)*0.1;
   if (Joystick1.XPosition>dzx) then  bus[mojnumer].kierownica:=(Joystick1.XPosition-dzx)*0.1;


       if (bus[mojnumer].kierownica>-1.5) and (bus[mojnumer].kierownica<1.5)
        and (wewn=false) and form2.checkbox11.Checked then begin
                bus[mojnumer].kierunek:=0;
                hud_ki.material.LibMaterialName:='ki_0';
                wewn:=true;
                bus[mojnumer].migaj;
       end;

   if (bus[mojnumer].kierownica<-1.5) or (bus[mojnumer].kierownica>1.5) then begin wewn:=false; bus[mojnumer].migaj; end;


     if (joybu[1] in joystick1.JoyButtons) and  (BASS_ChannelIsActive(ss[5])<>BASS_ACTIVE_PLAYING)
     then begin
     if not form2.CheckBox20.Checked then ss[5]:=BASS_sampleplay(sams[5]);
     end;

   if (joybu[3] in joystick1.JoyButtons) and (bus[mojnumer].kierunek<>1) then begin
        bus[mojnumer].kierunek:=1; tkier:=0;
        hud_ki.material.LibMaterialName:='ki_0';
        bus[mojnumer].migaj;
   end;


   if (joybu[4] in joystick1.JoyButtons) and (bus[mojnumer].kierunek<>2) then begin
        bus[mojnumer].kierunek:=2; tkier:=0;
        hud_ki.material.LibMaterialName:='ki_0';
        bus[mojnumer].migaj;
   end;


   if (joybu[2] in joystick1.JoyButtons) and (not p12) then
   begin
        p12:=true;
        if bus[mojnumer].kierunek>0 then begin bus[mojnumer].kierunek:=0; hud_ki.material.LibMaterialName:='ki_0'; end else bus[mojnumer].kierunek:=3;
        bus[mojnumer].migaj;
   end;

   if not (joybu[2] in joystick1.JoyButtons) then p12:=false;

end else
begin
///////////////////// czesc klawiaturowa
// log.wriln('hk05');

   if (Iskeydown(klaw[1])) and ((not dz) or (not bus[mojnumer].blokhamulca)) and (bus[mojnumer].opusz=0) then begin
        if bus[mojnumer].naped.throttle<1 then
                bus[mojnumer].naped.throttle:=bus[mojnumer].naped.throttle+deltatime
        else bus[mojnumer].naped.throttle:=1;
   end;
// log.wriln('hk06');
   if iskeydown(klaw[2]) then begin
        bus[mojnumer].stop:=true;
        if bus[mojnumer].naped.throttle>0 then
                bus[mojnumer].naped.throttle:=bus[mojnumer].naped.throttle-deltatime
        else begin
                bus[mojnumer].naped.throttle:=0;
                bus[mojnumer].naped.brake:=1;
        end;
   end;
// log.wriln('hk07');
   if not iskeydown(klaw[2]) then bus[mojnumer].naped.brake:=0;
   if not iskeydown(klaw[1]) then bus[mojnumer].naped.throttle:=bus[mojnumer].naped.throttle*0.9;


// log.wriln('hk08');
   if IsKeyDown(klaw[3]) and (bus[mojnumer].kierownica>-10) then begin
       bus[mojnumer].kierownica:=bus[mojnumer].kierownica-6*deltatime;
       if bus[mojnumer].kierownica>0 then bus[mojnumer].kierownica:=bus[mojnumer].kierownica-6*deltatime;
       if bus[mojnumer].kierownica>1.5 then wewn:=false;
       if (bus[mojnumer].kierownica<1.5) and (bus[mojnumer].kierownica>-1.5) and (wewn=false) and form2.checkbox11.Checked then begin bus[mojnumer].kierunek:=0;
       hud_ki.material.LibMaterialName:='ki_0';
       wewn:=true;
       bus[mojnumer].migaj;
       end ;
      skrent:=1;
   end;
// log.wriln('hk09');
   if bus[mojnumer].kierownica<-10 then bus[mojnumer].kierownica:=-10;

// log.wriln('hk10');

   if IsKeyDown(klaw[4]) and (bus[mojnumer].kierownica<10) then begin
   bus[mojnumer].kierownica:=bus[mojnumer].kierownica+6*deltatime;
       if bus[mojnumer].kierownica<0 then bus[mojnumer].kierownica:=bus[mojnumer].kierownica+6*deltatime;
       if bus[mojnumer].kierownica<-1.5 then wewn:=false;
       if (bus[mojnumer].kierownica>-1.5) and (bus[mojnumer].kierownica<1.5) and (wewn=false) and form2.checkbox11.Checked then begin bus[mojnumer].kierunek:=0;
       hud_ki.material.LibMaterialName:='ki_0';
       bus[mojnumer].migaj;
       wewn:=true;
       end;

       skrent:=2;
   end;
// log.wriln('hk11');
   if bus[mojnumer].kierownica>10 then bus[mojnumer].kierownica:=10;

// log.wriln('hk12');
     if iskeydown(klaw[5]) and  (BASS_ChannelIsActive(ss[5])<>BASS_ACTIVE_PLAYING)
     then begin
     if not form2.CheckBox20.Checked then      ss[5]:=BASS_sampleplay(sams[5]);
     end;

// log.wriln('hk13');
   if (skrent=0) and (bus[mojnumer].kierownica<>0) then begin
                if form2.checkbox12.Checked then begin
                        if bus[mojnumer].kierownica>0 then bus[mojnumer].kierownica:=bus[mojnumer].kierownica-9*deltatime*(abs(bus[mojnumer].naped.v)/8);
                        if bus[mojnumer].kierownica<0 then  bus[mojnumer].kierownica:=bus[mojnumer].kierownica+9*deltatime*(abs(bus[mojnumer].naped.v)/8);
                end;
                if (bus[mojnumer].kierownica>1.5) or (bus[mojnumer].kierownica<-1.5) then wewn:=false;
                if (bus[mojnumer].kierownica>-1.5) and (bus[mojnumer].kierownica<1.5) and (wewn=false) and
                form2.checkbox11.Checked then begin

                kier:=0;
                wewn:=true;
               bus[mojnumer].migaj;
                end;
                if (bus[mojnumer].kierownica>-0.7) and (bus[mojnumer].kierownica<0.7) then bus[mojnumer].kierownica:=0;
   end;
// log.wriln('hk14');
   if iskeydown(klaw[6]) and (bus[mojnumer].kierunek<>2) then begin
        //kier:=-1;
        tkier:=0;
        bus[mojnumer].kierunek:=2;
        bus[mojnumer].migaj;
{        if (bus[mojnumer].kierownica<1.5) and (bus[mojnumer].kierownica>-1.5) then wewn:=true
        else wewn:=false;}
   end;
// log.wriln('hk15');
   if iskeydown(klaw[7]) and (bus[mojnumer].kierunek<>1) then begin
        //kier:=1;
        tkier:=0;
        bus[mojnumer].kierunek:=1;
        bus[mojnumer].migaj;
{        if (bus[mojnumer].kierownica<1.5) and (bus[mojnumer].kierownica>-1.5) then wewn:=true
        else wewn:=false;}
   end;
// log.wriln('hk16');
   if (iskeydown(klaw[8])) and (not p12) then
   begin
        p12:=true;
        if bus[mojnumer].kierunek>0 then begin bus[mojnumer].kierunek:=0; hud_ki.material.LibMaterialName:='ki_0'; end else begin bus[mojnumer].kierunek:=3;
        hud_ki.material.LibMaterialName:='ki_0'; end;
        bus[mojnumer].migaj;
   end;

// log.wriln('hk17');
   if not iskeydown(klaw[8]) then begin
        p12:=false;
   end;



end;
//////////////////////koniec roznic miedzy klawiatura a joystickiem


{     if pred*pt<0 then begin accel:=0; pred:=0; end;
     if (bieg=0) and (pred*pt<0.2) then begin accel:=0; pred:=0; end;
}

// log.wriln('hk18');
   if (Iskeydown(klaw[54])) then begin
        getinfo;
   end;
// log.wriln('hk19');
   if iskeydown(klaw[50]) and not (acam_ll or acam_lr or acam_dl or acam_dr) then
        begin
        l_camera:=glfullscreenviewer1.Camera;
        glfullscreenviewer1.Camera:=cam_l_l;
        acam_ll:=true;
        end;
// log.wriln('hk20');
   if iskeydown(klaw[51]) and not (acam_ll or acam_lr or acam_dl or acam_dr) then
        begin
        l_camera:=glfullscreenviewer1.Camera;
        glfullscreenviewer1.Camera:=cam_l_r;
        acam_lr:=true;
        end;


// log.wriln('hk21');
   if iskeydown(klaw[52]) and not (acam_ll or acam_lr or acam_dl or acam_dr) then
        begin
        l_camera:=glfullscreenviewer1.Camera;
        glfullscreenviewer1.Camera:=cam_d_l;
        acam_dl:=true;
        end;
// log.wriln('hk22');
   if iskeydown(klaw[53]) and not (acam_ll or acam_lr or acam_dl or acam_dr) then
        begin
        l_camera:=glfullscreenviewer1.Camera;
        glfullscreenviewer1.Camera:=cam_d_r;
        acam_dr:=true;
        end;
// log.wriln('hk23');
   if (not iskeydown(klaw[53])) and acam_dr then
        begin
        glfullscreenviewer1.Camera:=l_camera;
        acam_dr:=false;
        end;
// log.wriln('hk24');
   if (not iskeydown( klaw[52])) and acam_dl then
        begin
        glfullscreenviewer1.Camera:=l_camera;
        acam_dl:=false;
        end;
 //log.wriln('hk25');
   if (not iskeydown(klaw[51])) and acam_lr then
        begin
        glfullscreenviewer1.Camera:=l_camera;
        acam_lr:=false;
        end;
 //log.wriln('hk26');
   if (not iskeydown(klaw[50])) and acam_ll then
        begin
        glfullscreenviewer1.Camera:=l_camera;
        acam_ll:=false;
        end;
 //log.wriln('hk27');




   if IsKeyDown(klaw[9]) then begin
//        glcamera5.Position.y:=glcamera5.Position.y+0.1;

   end;
 //log.wriln('hk28');
      if IsKeyDown(klaw[10]) then begin
//        glcamera5.Position.y:=glcamera5.Position.y-0.1;

   end;



 //log.wriln('hk29');

     if iskeydown(klaw[11]) and  (BASS_ChannelIsActive(ss[7])<>BASS_ACTIVE_PLAYING)
     then begin
     if not form2.CheckBox20.Checked then      ss[7]:=BASS_sampleplay(sams[7]);
     end;



{   if (iskeydown(klaw[12])) and (pred>-0.1) and (not dz) then begin pt:=1; bieg:=1; d_bieg.material.LibMaterialName:='d_t'; r_bieg.material.LibMaterialName:='r_n'; flare[31].visible:=false; end;

   if (iskeydown(klaw[13])) and (pred<0.1) and (not dz) then begin pt:=-1; bieg:=-1; d_bieg.material.LibMaterialName:='d_n'; r_bieg.material.LibMaterialName:='r_t'; flare[31].visible:=true; end;

   if iskeydown(klaw[14]) then begin bieg:=0; d_bieg.material.LibMaterialName:='d_n'; r_bieg.material.LibMaterialName:='r_n'; flare[31].visible:=false; end;
 }


 //pazze
{  if iskeydown(klaw[12]) then log.wriln('kbd-12');
  if iskeydown('Q') then log.wriln('kbd-Q');
  if p10 then log.wriln('p10+');            }


 //log.wriln('hk30');
  if (iskeydown(klaw[12]) and (not p10)) then begin bus[mojnumer].naped.gup; p10:=true; {log.wriln('g-UP'); }end;



 //log.wriln('hk31');
 if (iskeydown(klaw[14]) and (not p11)) then begin bus[mojnumer].naped.gdn; p11:=true; end;
 if (iskeydown(klaw[13])) then bus[mojnumer].naped.bieg:=0;
 //log.wriln('hk32');
 if (not iskeydown(klaw[12])) then p10:=false;
 if (not iskeydown(klaw[14])) then p11:=false;

 //log.wriln('hk33');
 if bus[mojnumer].dr0 then begin
  bus[mojnumer].pulpit.status[20]:=true;
  if iskeydown(klaw[48]) then begin
   if  not p0 then begin
    if not d0 then begin
                bus[mojnumer].drz[0].otworz;
             if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[2]);
                end
                else
                begin
                bus[mojnumer].drz[0].zamknij;
     if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[3]);
                end;
     d0:=not d0; p0:=true;
     end end
   else
  begin
   p0:=false;
    bus[mojnumer].pulpit.status[20]:=false;
  end;
end;


  if iskeydown(klaw[55]) then begin
   if  not pdk then begin
    if not ddk then begin
                bus[mojnumer].dk_rusz(1);
                end
                else
                begin
                bus[mojnumer].dk_rusz(2);
                end;
     ddk:=not ddk; pdk:=true;
     end end
   else
  begin
   pdk:=false;
   // bus[mojnumer].pulpit.status[6]:=false;
  end;


 moznaotwierac:=false;
 if bus[mojnumer].naped.v=0 then moznaotwierac:=true;
 if not bus[mojnumer].blokhamulca then moznaotwierac:=true;
 //log.wriln('hk34');

  if iskeydown(klaw[15]) then begin
    bus[mojnumer].pulpit.status[6]:=true;
   if moznaotwierac and not p1 then begin
     if not d1 then begin
                bus[mojnumer].drz[1].otworz;
                dr_1.material.LibMaterialName:='d_op';
     if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[2]);
//                d_op1.visible:=true;
                end
                else
                begin
                bus[mojnumer].drz[1].zamknij;
                dr_1.material.LibMaterialName:='d_cl';
     if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[3]);
//                d_op1.visible:=false;
                end;
     d1:=not d1; p1:=true;
     end end
   else
  begin
   p1:=false;
     bus[mojnumer].pulpit.status[6]:=false;
  end;


 //log.wriln('hk35');

if bus[mojnumer].liczbad > 1 then begin
  bus[mojnumer].pulpit.status[7]:=true;
  if iskeydown(klaw[16]) then begin
   if moznaotwierac  and not p2 then begin
      if not d2 then begin
                bus[mojnumer].drz[2].otworz;
     if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[2]);
                dr_2.material.LibMaterialName:='d_op';
//                d_op2.visible:=true;
                end
                else
                begin
                bus[mojnumer].drz[2].zamknij;
     if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[3]);
                dr_2.material.LibMaterialName:='d_cl';
//                d_op2.visible:=false;
                end;
      d2:=not d2; p2:=true;
      end end
   else
  begin
   p2:=false;
     bus[mojnumer].pulpit.status[7]:=false;
  end;
end;


 //log.wriln('hk36');

if bus[mojnumer].liczbad > 2 then begin
  bus[mojnumer].pulpit.status[8]:=true;
  if iskeydown(klaw[17]) then begin
   if moznaotwierac and not p3 then begin
      if not d3 then begin
                bus[mojnumer].drz[3].otworz;
     if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[2]);
                dr_3.material.LibMaterialName:='d_op';
//                d_op3.visible:=true;
                end
                else begin
                bus[mojnumer].drz[3].zamknij;
     if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[3]);
                dr_3.material.LibMaterialName:='d_cl';
//                d_op3.visible:=false;
                end;
      d3:=not d3; p3:=true;
      end  end
   else
  begin
   p3:=false;
   bus[mojnumer].pulpit.status[8]:=false;
  end;
end;


 //log.wriln('hk37');

if bus[mojnumer].liczbad > 3 then begin
  bus[mojnumer].pulpit.status[9]:=true;
  if iskeydown(klaw[18]) then begin
   if moznaotwierac  and not p4 then begin
      if not d4 then begin
                bus[mojnumer].drz[4].otworz;
     if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[2]);
                dr_4.material.LibMaterialName:='d_op';
//                d_op4.visible:=true;
                end
                else begin
                bus[mojnumer].drz[4].zamknij;
     if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[3]);
                dr_4.material.LibMaterialName:='d_cl';
//                d_op4.visible:=false;
                end;
      d4:=not d4; p4:=true;
      end  end
   else
  begin
   p4:=false;
     bus[mojnumer].pulpit.status[9]:=false;
  end;
end;


 //log.wriln('hk38');
  ldrz:=0;
  if d1 then  inc(ldrz);
  if d2 then  inc(ldrz);
  if d3 then  inc(ldrz);
  if d4 then  inc(ldrz);

bus[mojnumer].pulpit.status[1]:=d1;
bus[mojnumer].pulpit.status[2]:=d2;
bus[mojnumer].pulpit.status[3]:=d3;
bus[mojnumer].pulpit.status[4]:=d4;


 //log.wriln('hk39');


if iskeydown(klaw[19]) and (not p5) and moznaotwierac then begin
        p5:=true;
        if ldrz>0 then begin
        d1:=false;d2:=false;d3:=false;d4:=false;
     if not form2.CheckBox20.Checked then         BASS_sampleplay(sams[3]);
        dr_4.material.LibMaterialName:='d_cl';
//        d_op4.visible:=false;
        dr_3.material.LibMaterialName:='d_cl';
//        d_op3.visible:=false;
        dr_2.material.LibMaterialName:='d_cl';
//        d_op2.visible:=false;
        dr_1.material.LibMaterialName:='d_cl';
//        d_op1.visible:=false;
        for iloop:=1 to bus[mojnumer].liczbad do
        bus[mojnumer].drz[iloop].zamknij;
        end else
        begin
     if not form2.CheckBox20.Checked then                 BASS_sampleplay(sams[2]);
                d1:=true;dr_1.material.LibMaterialName:='d_op'; {d_op1.visible:=true;}
                bus[mojnumer].drz[1].otworz;
        if bus[mojnumer].liczbad>1 then begin d2:=true;dr_2.material.LibMaterialName:='d_op'; {d_op2.visible:=true;} bus[mojnumer].drz[2].otworz; end;
        if bus[mojnumer].liczbad>2 then begin d3:=true;dr_3.material.LibMaterialName:='d_op'; {d_op3.visible:=true;} bus[mojnumer].drz[3].otworz; end;
        if bus[mojnumer].liczbad>3 then begin d4:=true;dr_4.material.LibMaterialName:='d_op'; {d_op4.visible:=true;} bus[mojnumer].drz[4].otworz; end;
        end;

end;


 //log.wriln('hk40');

if (not iskeydown(klaw[19]) )then p5:=false;

 //log.wriln('hk41');

if iskeydown(klaw[20]) and (not p7) then begin
        bus[mojnumer].swiatla;
   p7:=true;
   if bus[mojnumer].plama_p.visible then hud_mi.material.LibMaterialName:='mi_1' else hud_mi.material.LibMaterialName:='mi_0';
end;

if (not iskeydown(klaw[20])) then p7:=false;


 //log.wriln('hk42');

if (bus[mojnumer].przyklek) then begin
  if iskeydown(klaw[21]) then begin
   if (bus[mojnumer].naped.v=0) then begin
     if (bus[mojnumer].opusz=0) then begin bus[mojnumer].opusz:=1; hud_przykl.Material.LibMaterialName:='p_1'; end;
     if (bus[mojnumer].opusz=3) then begin bus[mojnumer].opusz:=2; hud_przykl.Material.LibMaterialName:='p_0';end;
   end;
  end;
end;


 //log.wriln('hk43');

//stacyjka

if (iskeydown(klaw[49])) then bus[mojnumer].pulpit.status[17]:=true else bus[mojnumer].pulpit.status[17]:=false;

if (iskeydown(klaw[49]) and (bus[mojnumer].naped.bieg=0) and (bus[mojnumer].naped.v=0) and (not p6)) then
        begin   p6:=true;
                bus[mojnumer].naped.dziala:=not bus[mojnumer].naped.dziala;
                if not bus[mojnumer].naped.dziala then begin
                                eng.material.LibMaterialName:='eng2';
                                BASS_ChannelPause(sh);

                        end else begin
                                BASS_ChannelResume(sh);
                                eng.material.LibMaterialName:='eng1';

                        end;

        end;

 //log.wriln('hk44');

if (not iskeydown(klaw[49])) then p6:=false;



  ldrz:=0;
  if d1 then  inc(ldrz);
  if d2 then  inc(ldrz);
  if d3 then  inc(ldrz);
  if d4 then  inc(ldrz);

   dz:=d4 or (d1 or (d2 or d3));
   if (dz) and (bus[mojnumer].blokhamulca) then bus[mojnumer].stop:=true;

 //log.wriln('hk45');

if dz then begin
//log.wriln('dz');
        if ((sqr(-bus[mojnumer].posx-miasto.stops[miasto.ttable[miasto.przystanek].st].x)+
        sqr(bus[mojnumer].posy-miasto.stops[miasto.ttable[miasto.przystanek].st].y))
        <sqr(miasto.stops[miasto.ttable[miasto.przystanek].st].ang)) then
                begin
                if not nastopie then  begin
 //log.wriln('hk46');
//                                         label7.Caption:='xx';
                        nastopie:=true;
//                                           log.wriln('NASTOPIE1');

                        miasto.ttable[miasto.przystanek].at:=stime;
                        cznast:=0;
                        oso:=miasto.ttable[miasto.przystanek].oso;
                        osi:=miasto.ttable[miasto.przystanek].osi;
                        onop:=nop;
                end;
        end
end
else begin
 //log.wriln('hk47');
    if nastopie then begin
        nastopie:=false;
        //   log.wriln('hk48');
        // label7.Caption:='**';
        cznast:=0;
        miasto.ttable[miasto.przystanek].dt:=stime;

        ///stoart
        n_przystanek;
        //koniec
    end;
    //log.wriln('hk52');
    glcamera4.Parent:=srsw;
    glcamera4.Position.X:=-miasto.stops[miasto.ttable[miasto.przystanek].st].x;
    glcamera4.Position.z:=miasto.stops[miasto.ttable[miasto.przystanek].st].y;
    glcamera4.Position.y:=7;
    glcamera4.TargetObject:=bus[mojnumer].nadwozieA;
end;

if iskeydown(klaw[22]) then begin
        GLCamera1.AdjustDistanceToTarget(0.99);
end;
 //log.wriln('hk53');
if iskeydown(klaw[23]) then begin
     GLCamera1.AdjustDistanceToTarget(1.01);
end;


  if iskeydown(klaw[24]) then begin
      fl:=glfullscreenviewer1.camera.FocalLength;
      glfullscreenviewer1.camera.FocalLength:=fl+1;
      end;

     if iskeydown(klaw[25]) then begin
     fl:=glfullscreenviewer1.camera.FocalLength;
     glfullscreenviewer1.camera.FocalLength:=fl-1;
     end;
 //log.wriln('hk54');







  if iskeydown(klaw[26]) then begin
//      glcamera5.pitch(1);
      end;

     if iskeydown(klaw[27]) then begin
//      glcamera5.turn(-1);
      end;



{   if (iskeydown('X')) then kont:=0;             }

  if iskeydown(klaw[28]) then begin
  mp3stop;
  mp3fun:=0;
  end;
 //log.wriln('hk55');
  if iskeydown(klaw[29]) then begin
  mp3play(mp3cur);
  mp3fun:=1;
  end;

  if iskeydown(klaw[30]) and (mp3fun<>3) then begin
  if mp3cur>1 then begin mp3stop; mp3play(mp3cur-1); end else begin mp3stop; mp3play(mp3max); end;
  mp3fun:=3;
  end;

  if iskeydown(klaw[31]) and (mp3fun<>2) then begin
  if mp3cur<mp3max then begin mp3stop; mp3play(mp3cur+1); end else begin mp3stop; mp3play(1); end;
  mp3fun:=2;
  end;

  if (not iskeydown(klaw[31])) and (mp3fun=2) then mp3fun:=1;
  if (not iskeydown(klaw[30])) and (mp3fun=3) then mp3fun:=1;

 //log.wriln('hk56');


   if IsKeyDown(klaw[32]) then begin
   glfullscreenviewer1.Camera:=glcamera5;
   bus[mojnumer].szyja.Up.X:=1;
   bus[mojnumer].szyja.Up.y:=0;
   bus[mojnumer].szyja.Up.z:=0;
   glcamera5.Up.X:=1;
   glcamera5.Up.y:=0;
   glcamera5.Up.z:=0;
    bus[mojnumer].szyja.roll(180);
    glcamera5.Pitch(70);

{      glcamera5.pitch((my-y)/5);
      bus1.szyja.roll(-(mx-x)/5);
 }
      {
glcamera5.Turn(90);glcamera5.pitch(-16);


      }
   end;
 //log.wriln('hk57');
{   if IsKeyDown(klaw[33]) and  form2.CheckBox5.checked then begin
 //log.wriln('hk58');
    glsceneviewer2.visible:=true;
    glsceneviewer3.visible:=true;
   { glsceneviewer2.Enabled:=true;
    glsceneviewer3.Enabled:=true;  }

 {  end;
  }
{   if IsKeyDown(klaw[34]) and  form2.CheckBox5.checked then begin
    glsceneviewer2.visible:=false;
    glsceneviewer3.visible:=false;}
   { glsceneviewer2.Enabled:=false;
    glsceneviewer3.Enabled:=false;    }
{   end;}

   if IsKeyDown(klaw[35]) then begin
    glfullscreenviewer1.Camera:=glcamera3;
//    label3.Caption:='[F6]';

   end;

   if IsKeyDown(klaw[36]) then begin
    glfullscreenviewer1.Camera:=glcamera4;
//    log.wriln(floattostr(glcamera4.Position.X)+' '+floattostr(glcamera4.Position.y)+' '+floattostr(glcamera4.Position.z));
//    label3.Caption:='[F7]';

   end;

   if IsKeyDown(klaw[37]) then begin
    glfullscreenviewer1.Camera:=glcamera1;
//    label3.Caption:='[F8]';
    end;

    if IsKeyDown(klaw[38]) and not maks then begin
    maks:=true;
    form1.WindowState:=wsMaximized;

   end;

    if IsKeyDown(klaw[39]) and maks then begin
    maks:=false;
    form1.WindowState:=wsNormal;

   end;
 //log.wriln('hk59');
if(FileExists('model\'+form2.pmodel+'\'+unit2.Form2.ptekst+'\wysw.bus')) then begin
 if (sterownik.Visible=true) then begin
  if iskeydown(klaw[43]) then begin
     if (ster=0) then begin
     ster:=1; wylacz_ster:=0;
     end;
     if (ster=3) then begin
     ster:=2;
     wysw_ster_text.Visible:=true;
     wysw_ster_text_2.Visible:=true;
     wysw_ster_text_3.Visible:=false;
     wysw_ster_text_4.Visible:=false;
     wysw_ster_text_5.Visible:=false;
     wysw_ster_text_6.Visible:=false;
     end;
  end;
 end;
end
else
begin
wysw_ster_text.Text:='Brak pliku wysw.bus w dla tekstury.';
wysw_ster_text_2.Text:='Prawdopodobny brak definicji tablic.'
end;
 //log.wriln('hk60');
if (ster=3) then begin
if iskeydown(klaw[45]) and (sterownik.Visible=true) then begin
     wysw_ster_text.Visible:=true;
     wysw_ster_text_2.Visible:=true;
     wysw_ster_text_3.Visible:=false;
     wysw_ster_text_4.Visible:=false;
     wysw_ster_text_5.Visible:=false;
     wysw_ster_text_6.Visible:=false;
end;
end;
 //log.wriln('hk61');
if (ster=3) then begin
if iskeydown(klaw[46]) and (sterownik.Visible=true) then begin
     wysw_ster_text.Visible:=false;
     wysw_ster_text_2.Visible:=false;
     wysw_ster_text_3.Visible:=true;
     wysw_ster_text_4.Visible:=true;
     wysw_ster_text_5.Visible:=false;
     wysw_ster_text_6.Visible:=false;
end;
end;

if (ster=3) then begin
if iskeydown(klaw[47]) and (sterownik.Visible=true) then begin
     wysw_ster_text.Visible:=false;
     wysw_ster_text_2.Visible:=false;
     wysw_ster_text_3.Visible:=false;
     wysw_ster_text_4.Visible:=false;
     wysw_ster_text_5.Visible:=true;
     wysw_ster_text_6.Visible:=true;
end;
end;
 //log.wriln('hk62');
if iskeydown(klaw[44]) and (not p8) then begin
     sterownik.Visible:=not sterownik.Visible;
     p8:=true;
end;

if (not iskeydown(klaw[44])) then p8:=false;

if (ster=3) and (sterownik.Visible=true) then begin
     if iskeydown(klaw[40]) then begin
     if (kiernawysw>1) then dec(kiernawysw) else kiernawysw:=5;

 //       with kier1.Material do begin
//        Texture.Image.loadfromfile('bmps\kier'+inttostr(kiernawysw)+'.bmp');
   //     texture.disabled:=false;
  //      end;
   //     kier1.Visible:=true;
   //     kier2.Visible:=false;
        wygas.Visible:=false;

        wysw_ster_text.Text:='L: '+form2.edLinia.Text;
        wysw_ster_text_2.Text:='K: '+form2.tablice[kiernawysw].linia1;

        kat_wysw := ExtractFilePath(ParamStr(0));

        if(FileExists(kat_wysw+'tab\przod'+inttostr(kiernawysw)+'.bmp')) then
        begin
        with glmateriallibrary2.Materials[14] do begin
        Material.texture.image.loadfromfile(kat_wysw+'tab\przod'+inttostr(kiernawysw)+'.bmp');
        log.wriln(kat_wysw+'tab\przod'+inttostr(kiernawysw)+'.bmp');
        Name:='tb_p';
        material.texture.disabled:=false;
        //        material.blendingmode:=bmAdditive;
        end;
        end;
        if(FileExists(kat_wysw+'tab\bok'+inttostr(kiernawysw)+'.bmp')) then
        begin
        with glmateriallibrary2.Materials[15] do begin
        Material.texture.image.loadfromfile(kat_wysw+'tab\bok'+inttostr(kiernawysw)+'.bmp');
        Name:='tb_b';
        material.texture.disabled:=false;
        //        material.blendingmode:=bmAdditive;
        end;
        end;
        if(FileExists(kat_wysw+'tab\tyl'+inttostr(kiernawysw)+'.bmp')) then
        begin
        with glmateriallibrary2.Materials[16] do begin
        Material.texture.image.loadfromfile(kat_wysw+'tab\tyl'+inttostr(kiernawysw)+'.bmp');
        Name:='tb_t';
        material.texture.disabled:=false;
        //        material.blendingmode:=bmAdditive;
        end;
        end;

        if (FileExists(kat_wysw+'tab\przod'+inttostr(kiernawysw)+'.bmp')) then bus[mojnumer].wysw_przod.Visible:=true;
        if (FileExists(kat_wysw+'tab\bok'+inttostr(kiernawysw)+'.bmp')) then bus[mojnumer].wysw_bok.Visible:=true;
        if (FileExists(kat_wysw+'tab\bok'+inttostr(kiernawysw)+'.bmp')) then bus[mojnumer].wysw_bok_dwa.Visible:=true;
        if (FileExists(kat_wysw+'tab\tyl'+inttostr(kiernawysw)+'.bmp')) then bus[mojnumer].wysw_tyl.Visible:=true;
        bus[mojnumer].wysw_przod.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_bok.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_bok_dwa.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_tyl.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_przod.material.LibMaterialName:='tb_p';
        bus[mojnumer].wysw_bok.material.LibMaterialName:='tb_b';
        bus[mojnumer].wysw_bok_dwa.material.LibMaterialName:='tb_b';
        bus[mojnumer].wysw_tyl.material.LibMaterialName:='tb_t';
     end;
end;
 //log.wriln('hk64');
if (ster=3) and (sterownik.Visible=true) then begin
     if iskeydown(klaw[41]) then begin
     if (kiernawysw<5) then inc(kiernawysw) else kiernawysw:=1;
    //    with kier2.Material do begin

        //Texture.Image.loadfromfile('bmps\kier'+inttostr(kiernawysw)+'.bmp');
//        texture.disabled:=false;
//        end;
 //       kier1.Visible:=false;
 //       kier2.Visible:=true;
        wygas.Visible:=false;

        wysw_ster_text.Text:='L: '+form2.edLinia.Text;
        wysw_ster_text_2.Text:='K: '+form2.tablice[kiernawysw].linia1;

        kat_wysw := ExtractFilePath(ParamStr(0));

        if(FileExists(kat_wysw+'tab\przod'+inttostr(kiernawysw)+'.bmp')) then
        begin
        with glmateriallibrary2.Materials[14] do begin
        Material.texture.image.loadfromfile(kat_wysw+'tab\przod'+inttostr(kiernawysw)+'.bmp');
        Name:='tb_p';
        material.texture.disabled:=false;
        //        material.blendingmode:=bmAdditive;
        end;
        end;
        if(FileExists(kat_wysw+'tab\bok'+inttostr(kiernawysw)+'.bmp')) then
        begin
        with glmateriallibrary2.Materials[15] do begin
        Material.texture.image.loadfromfile(kat_wysw+'tab\bok'+inttostr(kiernawysw)+'.bmp');
        Name:='tb_b';
        material.texture.disabled:=false;
        //        material.blendingmode:=bmAdditive;
        end;
        end;
        if(FileExists(kat_wysw+'tab\tyl'+inttostr(kiernawysw)+'.bmp')) then
        begin
        with glmateriallibrary2.Materials[16] do begin
        Material.texture.image.loadfromfile(kat_wysw+'tab\tyl'+inttostr(kiernawysw)+'.bmp');
        Name:='tb_t';
        material.texture.disabled:=false;
        //        material.blendingmode:=bmAdditive;
        end;
        end;

        if (FileExists(kat_wysw+'tab\przod'+inttostr(kiernawysw)+'.bmp')) then bus[mojnumer].wysw_przod.Visible:=true;
        if (FileExists(kat_wysw+'tab\bok'+inttostr(kiernawysw)+'.bmp')) then bus[mojnumer].wysw_bok.Visible:=true;
        if (FileExists(kat_wysw+'tab\bok'+inttostr(kiernawysw)+'.bmp')) then bus[mojnumer].wysw_bok_dwa.Visible:=true;
        if (FileExists(kat_wysw+'tab\tyl'+inttostr(kiernawysw)+'.bmp')) then bus[mojnumer].wysw_tyl.Visible:=true;
        bus[mojnumer].wysw_przod.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_bok.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_bok_dwa.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_tyl.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_przod.material.LibMaterialName:='tb_p';
        bus[mojnumer].wysw_bok.material.LibMaterialName:='tb_b';
        bus[mojnumer].wysw_bok_dwa.material.LibMaterialName:='tb_b';
        bus[mojnumer].wysw_tyl.material.LibMaterialName:='tb_t';
     end;
end;
 //log.wriln('hk65');
if (ster=3) and (sterownik.Visible=true) then begin
     if iskeydown(klaw[42]) then begin
        kier1.Visible:=false;
        kier2.Visible:=false;

        wysw_ster_text.Text:='Gotowy do pracy.';
        wysw_ster_text_2.Text:='System aktywny.';

        bus[mojnumer].wysw_przod.Visible:=false;
        bus[mojnumer].wysw_bok.Visible:=false;
        bus[mojnumer].wysw_bok_dwa.Visible:=false;
        bus[mojnumer].wysw_tyl.Visible:=false;
        bus[mojnumer].wysw_przod.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_bok.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_bok_dwa.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_tyl.Material.MaterialLibrary:=glmateriallibrary2;
        bus[mojnumer].wysw_przod.material.LibMaterialName:='tb_bp';
        bus[mojnumer].wysw_bok.material.LibMaterialName:='tb_bb';
        bus[mojnumer].wysw_bok_dwa.material.LibMaterialName:='tb_bb';
        bus[mojnumer].wysw_tyl.material.LibMaterialName:='tb_bt';
     end;
end;
 //log.wriln('hk66');
end; //koniec sprawdzania na pauze
//pause/break
if iskeydown(VK_PAUSE) and not pauk then begin
        pauk:=true;
        if not pau then begin
                pczas:=stime;
                pau:=true;
                end else
                begin
                miasto.rczas:=miasto.rczas+(stime-pczas);
                pau:=false;
                end;
        end;

if ((not iskeydown(VK_PAUSE)) and pauk )then pauk:=false;


//   end; //koniec active window

end;


procedure TForm1.FormCreate(Sender: TObject);
  var t:tscreen;
  cdir:string;
  iloop:integer;
begin
MAXBUS:=1;
log:=tmklogger.create(extractfiledir(application.exename)+'\log.txt');
log.czysc;
 log.wriln('start '+form2.label8.Caption);
//pojemnoscbusa:=30;
kiernawysw:=1;
enmatlib.Materials.Add;
enmatlib.Materials.Add;
enmatlib.Materials[0].Material.texture.disabled:=false;
enmatlib.Materials[1].Material.texture.disabled:=false;
enmatlib.Materials[0].name:='eng1';
enmatlib.Materials[1].name:='eng2';
enmatlib.Materials[0].Material.texture.image.loadfromfile('bmps\en1.bmp');
enmatlib.Materials[1].Material.texture.image.loadfromfile('bmps\en2.bmp');
 eng.Material.MaterialLibrary:=enmatlib;
 eng.material.LibMaterialName:='eng2';

 log.wriln('materials');
for iloop:=1 to 29 do glmateriallibrary2.Materials.Add;




with glmateriallibrary2.Materials[1] do begin
        Material.texture.image.loadfromfile('bmps\d_op.bmp');
        Name:='d_op';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;
with glmateriallibrary2.Materials[2] do begin
        Material.texture.image.loadfromfile('bmps\d_cl.bmp');
        Name:='d_cl';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;

with glmateriallibrary2.Materials[3] do begin
        Material.texture.image.loadfromfile('bmps\sk3_y.bmp');
        Name:='sk3_y';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;

with glmateriallibrary2.Materials[4] do begin
        Material.texture.image.loadfromfile('bmps\sk3_g.bmp');
        Name:='sk3_g';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;


with glmateriallibrary2.Materials[5] do begin
        Material.texture.image.loadfromfile('tab\blank_przod_myl.bmp');
        Name:='tb_bp';
        material.texture.disabled:=false;
//      material.blendingmode:=bmAdditive;
end;
with glmateriallibrary2.Materials[6] do begin
        Material.texture.image.loadfromfile('tab\blank_bok_myl.bmp');
        Name:='tb_bb';
        material.texture.disabled:=false;
//      material.blendingmode:=bmAdditive;
end;
with glmateriallibrary2.Materials[7] do begin
        Material.texture.image.loadfromfile('tab\blank_tyl_myl.bmp');
        Name:='tb_bt';
        material.texture.disabled:=false;
//      material.blendingmode:=bmAdditive;
end;
with glmateriallibrary2.Materials[8] do begin
        Material.texture.image.loadfromfile('bmps\ki_0.bmp');
        Name:='ki_0';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;
with glmateriallibrary2.Materials[9] do begin
        Material.texture.image.loadfromfile('bmps\ki_1.bmp');
        Name:='ki_1';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;
with glmateriallibrary2.Materials[10] do begin
        Material.texture.image.loadfromfile('bmps\mi_0.bmp');
        Name:='mi_0';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;
with glmateriallibrary2.Materials[11] do begin
        Material.texture.image.loadfromfile('bmps\mi_1.bmp');
        Name:='mi_1';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;
with glmateriallibrary2.Materials[12] do begin
//        Material.texture.image.loadfromfile('bmps\r_t.bmp');
        Name:='r_t';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;

with glmateriallibrary2.Materials[17] do begin
        Material.texture.image.loadfromfile('bmps\p_0.bmp');
        Name:='p_0';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;
with glmateriallibrary2.Materials[18] do begin
        Material.texture.image.loadfromfile('bmps\p_1.bmp');
        Name:='p_1';
        material.texture.disabled:=false;
        material.blendingmode:=bmAdditive;
end;


with podklad_napisy.Material do begin
        Texture.Image.loadfromfile('bmps\podklad_napisy.bmp');
//        blendingmode:=bmAdditive;
        texture.disabled:=false;
end;

with glhudsprite1.Material do begin
        Texture.Image.loadfromfile('bmps\zegary.bmp');
        blendingmode:=bmAdditive;
        texture.disabled:=false;
end;

with sterownik.Material do begin
        Texture.Image.loadfromfile('bmps\sterownik.bmp');
//        blendingmode:=bmAdditive;
        texture.disabled:=false;
end;

with sk1.Material do begin
        Texture.Image.loadfromfile('bmps\sk.bmp');
        blendingmode:=bmAdditive;
        texture.disabled:=false;
end;

with sk9.Material do begin
        Texture.Image.loadfromfile('bmps\sk.bmp');
        blendingmode:=bmAdditive;
        texture.disabled:=false;
end;

with sk3.Material do begin
        Texture.Image.loadfromfile('bmps\sk.bmp');
        blendingmode:=bmAdditive;
        texture.disabled:=false;
end;

hud_ki.Material.MaterialLibrary:=glmateriallibrary2;
hud_mi.Material.MaterialLibrary:=glmateriallibrary2;
r_bieg.Material.MaterialLibrary:=glmateriallibrary2;
dr_1.Material.MaterialLibrary:=glmateriallibrary2;
dr_2.Material.MaterialLibrary:=glmateriallibrary2;
dr_3.Material.MaterialLibrary:=glmateriallibrary2;
dr_4.Material.MaterialLibrary:=glmateriallibrary2;
sk3.Material.MaterialLibrary:=glmateriallibrary2;
hud_przykl.Material.MaterialLibrary:=glmateriallibrary2;
dr_1.material.LibMaterialName:='d_cl';
dr_2.material.LibMaterialName:='d_cl';
dr_3.material.LibMaterialName:='d_cl';
dr_4.material.LibMaterialName:='d_cl';
sk3.material.LibMaterialName:='sk3_g';
hud_ki.material.LibMaterialName:='ki_0';
hud_mi.material.LibMaterialName:='mi_0';
r_bieg.material.LibMaterialName:='r_n';
hud_przykl.Material.LibMaterialName:='p_0';



    licznik_t:=0;




{image1.Picture.Bitmap.Create;}
randomize;
lustrolewe.TurnAngle:=91;
lustroprawe.TurnAngle:=89;
//pmodel2:='grr';
postoj:=false;
kier:=0;
form1.Left:=round(t.Width/2-form1.width/2);
form1.top:=round(t.height/2-form1.height/2);

maks:=false;
nastopie:=false;
decimalseparator:='.';
TimeSeparator:=':';
//stringgrid1.ColWidths[0]:=180;
//stringgrid1.ColWidths[1]:=40;


nop:=0;



log.wri('bassinit');
BASS_Init(-1, 44100, 0, handle,nil);

log.wriln('..ok');
log.wri('bassstart');
BASS_Start;
log.wriln('..ok');
cdir:=getcurrentdir;
//panel.Visible:=false;
log.wriln('formcreate..ok');
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
{spred:=-trackbar1.position/10;  }
end;


procedure TForm1.GLCadencer1Progress(Sender: TObject; const deltaTime,
  newTime: Double);

  var i:integer;
  var
   rayStart, rayVector, iPoint, iNormal : TVector;

   m:integer;
begin
//log.wriln('cad01');
if form2.connected then stime:=servertime else stime:=time-miasto.rczas;

//_delta:=_delta+deltatime;

//if _delta>0.01 then       _delta:=0;
//log.wriln('cad02');
bus[mojnumer].policz(deltatime);
//log.wriln('cad03');
    for i:=1 to MAXBUS do  begin
     //   log.wri('bus '+inttostr(i)+':');
       bus[i].rusz(deltatime);
       end;
//log.wriln('cad04');
{log.wriln(format('BUS %.2f %.2f %.2f',[bus[mojnumer].podwoziea.absoluteposition[0],
                                        bus[mojnumer].podwoziea.absoluteposition[1],
                                        bus[mojnumer].podwoziea.absoluteposition[2]]));
                                        }
                                        {
log.wriln(format('LUSTRO %.2f %.2f %.2f',[lustrolewe.absoluteposition[0],
                                        lustrolewe.absoluteposition[1],
                                        lustrolewe.absoluteposition[2]])); }

if miasto.trawa then rusztrawe;
//log.wriln('cad05');
if form2.trafik then traffic.rusz(deltatime);
//log.wriln('cad06');

//log.wriln('cad09');
      HandleKeys(deltaTime);
//log.wriln('cad10');
if not pau then begin   //pauza ?
//log.wriln('cad11');

if miasto.ulicesa then begin
//log.wriln('cad12');
setvector(raystart,bus[mojnumer].czujnik.absoluteposition);

   SetVector(rayVector, 0,-1,0);
   NormalizeVector(rayVector);
   if not miasto.ulice.RayCastIntersect(rayStart, rayVector, @iPoint, @iNormal) and (bus[mojnumer].naped.v>3) then begin
        bus[mojnumer].naped.throttle:=0;
        bus[mojnumer].naped.brake:=1.5;
   end;




end else begin
end;

//log.wriln('cad13');


//pred:=bus[mojnumer].naped.v;

{if (pred<=vmax) and (pred>=vmin) then pred:=pred+a*pt*deltatime;
if pred>vmax then pred:=vmax;
if pred<vmin then pred:=vmin;}


m:=5000+trunc(bus[mojnumer].naped.rpm*6);
//log.wriln('cad14');
 BASS_ChannelSetAttributes( sh,m,-1,-101);
//if bus[mojnumer].naped.rpm<10 then BASS_ChannelPause(sh);




//log.wriln('cad15');
//--------------------------------------------------
if (ster=1) then begin
     Timer3.Enabled:=True;
     wlacz.Visible:=true;
     with wlacz.Material do begin
     Texture.Image.loadfromfile('bmps\wlacz.bmp');
     texture.disabled:=false;
     wysw_ster_text.Text:='Prosze czekac.';
     wysw_ster_zegar.Visible:=true;
     end;
end;
//log.wriln('cad16');
if (ster=2) then begin
Timer4.Enabled:=True;
wysw_ster_text.Text:='Prosze czekac.';
wysw_ster_text_2.Text:=' ';
end;
//log.wriln('cad17');
if (wlacz_ster=1) then begin
wysw1.NazwaLinii:='tab\akt.lin';

wysw_ster_text.Text:='Prosze czekac..';
wysw_ster_text_2.Text:='Sprawdzanie urzadzen...';
end;
//log.wriln('cad18');
if (wylacz_ster=1) then begin
kier1.Visible:=false;
kier2.Visible:=false;
bus[mojnumer].wysw_przod.Visible:=false;
bus[mojnumer].wysw_bok.Visible:=false;
bus[mojnumer].wysw_bok_dwa.Visible:=false;
bus[mojnumer].wysw_tyl.Visible:=false;
bus[mojnumer].wysw_przod.Material.MaterialLibrary:=glmateriallibrary2;
bus[mojnumer].wysw_bok.Material.MaterialLibrary:=glmateriallibrary2;
bus[mojnumer].wysw_bok_dwa.Material.MaterialLibrary:=glmateriallibrary2;
bus[mojnumer].wysw_tyl.Material.MaterialLibrary:=glmateriallibrary2;
bus[mojnumer].wysw_przod.material.LibMaterialName:='tb_bp';
bus[mojnumer].wysw_bok.material.LibMaterialName:='tb_bb';
bus[mojnumer].wysw_bok_dwa.material.LibMaterialName:='tb_bb';
bus[mojnumer].wysw_tyl.material.LibMaterialName:='tb_bt';

DeleteFile(kat_wysw+'tab\przod1.bmp');
DeleteFile(kat_wysw+'tab\bok1.bmp');
DeleteFile(kat_wysw+'tab\tyl1.bmp');

wysw_ster_text.Text:='Prosze czekac..';
wysw_ster_text_2.Text:='Wylaczanie urzadzen...';
end;
//log.wriln('cad19');
if (wlacz_ster=2) then begin
//if (wysw1.kier<5) then inc(wysw1.kier) else wysw1.kier:=1;
wysw1.kier:=2;
wysw1.NazwaLinii:='tab\akt.lin';
Wyswietlacze.WczytajBusa;
{
for ii:=1 to 5 do begin
wysw1.kier:=ii;
For i:=1 to wysw1.Bus.Iltablic do Wyswietlacze.KreujTablice(wysw1.Bus.Tablice[i]);
end;    }
wysw_ster_text.Text:='Prosze czekac...';
wysw_ster_text_2.Text:='OK...';
end;
//log.wriln('cad19');
if (wylacz_ster=2) then begin
DeleteFile(kat_wysw+'tab\przod2.bmp');
DeleteFile(kat_wysw+'tab\bok2.bmp');
DeleteFile(kat_wysw+'tab\tyl2.bmp');

wysw_ster_text.Text:='Prosze czekac...';
wysw_ster_text_2.Text:='OK...';
end;
//log.wriln('cad20');
if (wlacz_ster=3) then begin
ster:=3;
wysw_ster_text.Text:='Prosze czekac....';
wysw_ster_text_2.Text:='Wczytywanie danych...';
end;
//log.wriln('cad21');
if (wylacz_ster=3) then begin
ster:=0;
wysw_ster_text.Text:='Prosze czekac....';
wysw_ster_text_2.Text:='Do widzenia! Milego dnia!';
end;
//log.wriln('cad21');
if (wlacz_ster=4) then begin
Timer3.Enabled:=False;
wysw_ster_text.Text:='Gotowy do pracy';
wysw_ster_text_2.Text:='Witaj! Szerokiej drogi!';
wlacz_ster:=0;
end;
//log.wriln('cad22');
if (wylacz_ster=4) then begin
Timer4.Enabled:=False;
wlacz.visible:=False;
wysw_ster_text.Text:='';
wysw_ster_text_2.Text:='';
wysw_ster_zegar.Visible:=false;
end;
//--------------------------------------------------
//log.wriln('cad23');
if (bus[mojnumer].naped.v<0.001) and postoj and
 ((sqr(-bus[mojnumer].posx-miasto.stops[miasto.ttable[miasto.przystanek].st].x)+
 sqr(bus[mojnumer].posy-miasto.stops[miasto.ttable[miasto.przystanek].st].y))<
 sqr(miasto.stops[miasto.ttable[miasto.przystanek].st].ang))
 then begin
   miasto.ttable[miasto.przystanek].at:=stime;
   miasto.ttable[miasto.przystanek].dt:=stime;
//log.wriln('cad24');



/////start

n_przystanek;
    ////konmiec
   glcamera4.Position.X:=miasto.stops[miasto.ttable[miasto.przystanek].st].x;
   glcamera4.Position.z:=miasto.stops[miasto.ttable[miasto.przystanek].st].y;
   glcamera4.Position.y:=3;
   glcamera4.TargetObject:=bus[mojnumer].nadwozieA;
 end;
//log.wriln('cad26');
//dir:=dir-kont*pred*deltatime*1.5;



// adosr:=(a*deltatime)*(a*deltatime)*sin(kont)/rozstaw;




                        {
if posx>maxx then posx:=maxx;
if posx<minx then posx:=minx;
if posy>maxz then posy:=maxz;
if posy<minz then posy:=minz; }


{glcamera3.position.x:=posx;
glcamera3.position.z:=posy;
 }

if nastopie and (ldrz>0) then begin
  cznast:=cznast-deltatime;
   if cznast<0 then begin
       cznast:=1.5/ldrz; //spowolnienie pasazerow
       if oso>0 then begin dec(oso); dec(onop); end else
           if (osi>0) and (onop<bus[mojnumer].pojemnoscbusa) then begin dec(osi); inc(onop); end;
       end;

   przystanek_liczba.Text:=inttostr(osi);
   bus_liczba_2.Text:=inttostr(oso);
   bus_liczba_1.Text:=inttostr(onop);
   bus[mojnumer].pokazludzi(onop);
 if form2.CheckBox19.Checked then begin
   pasa.vis:=osi;
   pasa.pokaz;
   end;
  end;
//log.wriln('cad27');


tkier:=tkier+deltatime;
if tkier>0.5 then begin
   tkier:=0  ;
   for i:=1 to MAXBUS do begin bus[i].migaj;
   if (i=mojnumer) and (bus[mojnumer].kierunek>0) then begin
 //  log.wriln('migaj2');
  if not form2.CheckBox20.Checked then begin
    if k_on then BASS_sampleplay(sams[4]) else BASS_sampleplay(sams[6]);
    end;
    k_on:=not k_on;
    if bus[mojnumer].mig then hud_ki.material.LibMaterialName:='ki_1' else hud_ki.material.LibMaterialName:='ki_0';
   end;
   end;
end;







//k_kierownica.rollAngle:=-kont*360*1/9;
//log.wriln('cad28');
{segmentB}


end; //pauza ?

end;

procedure TForm1.Timer1Timer(Sender: TObject);
var di:real;
  a_ang:real;
begin
di:=(sqr(-bus[mojnumer].posx-miasto.stops[miasto.ttable[miasto.przystanek].st].x)+
     sqr(bus[mojnumer].posy-miasto.stops[miasto.ttable[miasto.przystanek].st].y));

 if form2.CheckBox22.Checked then begin

 hud_servermsg.text:=Format('%.2f km/h; thr %.2f; FPS %.2f; %.1f; kier=%f; joy=%d',
        [
         bus[mojnumer].naped.v*3.6,
         bus[mojnumer].naped.throttle,
         GLfullscreenViewer1.buffer.framespersecond,

         bus[mojnumer].kilom,
         bus[mojnumer].kierownica,
         Joystick1.XPosition
         ]);
	GLfullscreenViewer1.buffer.ResetPerformanceMonitor;
end;

hud_bieg.Text:=inttostr(bus[mojnumer].naped.bieg);
//log.wriln('cad07');
if bus[mojnumer].naped.bieg=0 then hud_bieg.Text:='N';
//log.wriln('cad08');
if bus[mojnumer].naped.bieg=-1 then hud_bieg.Text:='R';

//caption:=Format('%.2f FPS; dist=%.2f; V=%.2f; x=%.2f; y=%.2f, cznst %.2f, kier= %.8f, sin %.8f', [GLSceneViewer1.FramesPerSecond,sqrt(di),pred,-posx+15,posy+15,cznast,kont,sin(kont)]);

{caption:=Format('rollangle %.2f ; opusz=%d; ', [dummycube2.rollangle,opusz]);}




{
caption:=format ('%.8f, %.8f, %.8f, %.8f, %.8f',
[di,-bus[mojnumer].posx-miasto.stops[miasto.ttable[miasto.przystanek].st].x,
     bus[mojnumer].posy-miasto.stops[miasto.ttable[miasto.przystanek].st].y,
posx,
posy]);
}

if not pau then wysw_ster_zegar.Text:=timetostr(stime);

{caption:=format ('%.2f , %.2f, %.2f, %.2f',[minx,miny,maxx,maxy]);}

  a_ang:=arctan2(bus[mojnumer].posy-miasto.stops[miasto.ttable[miasto.przystanek].st].y,
                -bus[mojnumer].posx-miasto.stops[miasto.ttable[miasto.przystanek].st].x);


if di>sqr(miasto.stops[miasto.ttable[miasto.przystanek].st].ang) then sk3.material.LibMaterialName:='sk3_y' else sk3.material.LibMaterialName:='sk3_g';

  sk3.Rotation:=a_ang*180/pi+bus[mojnumer].dir;
  hud_dist.Text:=format('%.2f',[sqrt(di)]);

bus[mojnumer].strzala.turnAngle:=-a_ang*180/pi-bus[mojnumer].dir;

if di>sqr(miasto.stops[miasto.ttable[miasto.przystanek].st].ang) then bus[mojnumer].strzala.Material.FrontProperties.diffuse.color:=clrBrightGold else
bus[mojnumer].strzala.Material.FrontProperties.diffuse.color:=clrMediumSpringGreen;

end;

procedure tform1.zamykaj;
var a:integer;
begin
BASS_Free();
form3.memo1.lines.add(form2.nap[2]);
for a:=1 to miasto.maxprzy do begin
form3.Memo1.lines.add(form2.nap[3]+inttostr(a)+'  '+miasto.stops[miasto.ttable[a].st].name);
form3.Memo1.lines.add(form2.nap[4]+' :');
form3.Memo1.lines.add('   '+form2.nap[5]+' '+timetostr(miasto.ttable[a].t));
form3.Memo1.lines.add('   '+form2.nap[6]+' '+timetostr(miasto.ttable[a].at));
form3.Memo1.lines.add('   '+form2.nap[7]+' '+timetostr(miasto.ttable[a].dt));
form3.Memo1.lines.add(' '+form2.nap[8]+' :');
form3.Memo1.lines.add('   '+form2.nap[9]+' '+inttostr(miasto.ttable[a].oso));
form3.Memo1.lines.add('   '+form2.nap[10]+' '+inttostr(miasto.ttable[a].osi));
form3.Memo1.lines.add(' ---' );
end;

form3.show;
//Action := caFree;
end;


procedure TForm1.FormShow(Sender: TObject);
begin
//startuj;
end;

procedure tform1.startuj;
var f:textfile;
i,j,mi,mj:integer;

typ:integer;



//czyrozklad:boolean;

proxyname:string;


ii:integer;
glskybox1:tglskybox;
begin
if form2.CheckBox22.Checked=false then log.wriln('DEB disabled');
log.loguj:=form2.checkbox22.checked;

nettimer.Interval:=1000 div form2.trackbar1.Position;

if form2.connected then MAXBUS:=4;
mojnumer:=form2.mojnumer;
miasto:=tmiasto.create;
//log.wriln('mojnumer '+inttostr(mojnumer));
//log.wriln('mojnumer '+inttostr(form2.mojnumer));
if form2.CheckBox16.Checked then begin
log.wri('skybox');
for i:=1 to 6 do skyboxmatlib.materials.add;
if form2.checkbox9.Checked then begin
skyboxmatlib.materials[0].material.texture.image.loadfromfile('skybox\n_dn.jpg');
skyboxmatlib.materials[1].material.texture.image.loadfromfile('skybox\n_up.jpg');
skyboxmatlib.materials[2].material.texture.image.loadfromfile('skybox\n_bk.jpg');
skyboxmatlib.materials[3].material.texture.image.loadfromfile('skybox\n_ft.jpg');
skyboxmatlib.materials[4].material.texture.image.loadfromfile('skybox\n_lt.jpg');
skyboxmatlib.materials[5].material.texture.image.loadfromfile('skybox\n_rt.jpg');
end else begin
skyboxmatlib.materials[0].material.texture.image.loadfromfile('skybox\dn.jpg');
skyboxmatlib.materials[1].material.texture.image.loadfromfile('skybox\up.jpg');
skyboxmatlib.materials[2].material.texture.image.loadfromfile('skybox\bk.jpg');
skyboxmatlib.materials[3].material.texture.image.loadfromfile('skybox\ft.jpg');
skyboxmatlib.materials[4].material.texture.image.loadfromfile('skybox\lt.jpg');
skyboxmatlib.materials[5].material.texture.image.loadfromfile('skybox\rt.jpg');
end;
skyboxmatlib.materials[0].name:='dn';
skyboxmatlib.materials[1].name:='up';
skyboxmatlib.materials[2].name:='bk';
skyboxmatlib.materials[3].name:='ft';
skyboxmatlib.materials[4].name:='lt';
skyboxmatlib.materials[5].name:='rt';

for i:=0 to 5 do begin
        skyboxmatlib.Materials[i].Material.Texture.Enabled:=true;
end;

glskybox1:=TGLskybox(tuskybox.addnewchild(TGLskybox));
glskybox1.MaterialLibrary:=skyboxmatlib;

glskybox1.MatNameTop:='up';
glskybox1.MatNameBottom:='dn';
glskybox1.MatNameLeft:='lt';
glskybox1.MatNameRight:='rt';
glskybox1.MatNameFront:='ft';
glskybox1.MatNameBack:='bk';

glskydome1.Destroy;
log.wriln('...ok');
end
else
begin
log.wriln('skydome');
//glskybox1.Destroy;
end;




log.wri('joyst.bu');
assignfile(f,'joyst.bu');
reset(f);
for i:=1 to 4 do begin
        readln(f,j);
        case j of
        1: joybu[i]:=jbbutton1;
        2: joybu[i]:=jbbutton2;
        3: joybu[i]:=jbbutton3;
        4: joybu[i]:=jbbutton4;
        end;
end;
        readln(f,dzy);
        readln(f,dzX);
i:=1;
repeat
        readln(f,j);
        klaw[i]:=j;
        inc(i);
until eof(f);

closefile(f);
log.wriln('...ok');

log.wriln('wyswietlacze');
Wyswietlacze.WczytajBusa;
for ii:=1 to 5 do begin
wysw1.kier:=ii;
log.wriln('W:'+inttostr(wysw1.kier));
For i:=1 to wysw1.Bus.Iltablic do Wyswietlacze.KreujTablice(wysw1.Bus.Tablice[i]);
end;
log.wriln('wysw..ok');




mp3scan;


//panel.Visible:=True;
//panel.Caption:=form2.nap[25]+'...';
//glsceneviewer1.visible:=true;

//glsceneviewer1.enabled:=true;




//pmodel2:=unit2.Form2.pmodel;
bus_text.Text:=form2.nap[23];
przystanek_text.Text:=form2.nap[24];
//label7.caption:=form2.nap[21];
//grPredkosciomierz.caption:=form2.nap[26];
proxyname:='---';



//czyrozklad:=false;
//ulicesa:=false;
//szer:=12;

        case form2.ComboBox4.ItemIndex of
        0: begin glfullscreenviewer1.Width:=640;
                 glfullscreenviewer1.height:=480;
                 end;
        1: begin glfullscreenviewer1.Width:=800;
                 glfullscreenviewer1.height:=600;
                 end;
        2: begin glfullscreenviewer1.Width:=1024;
                 glfullscreenviewer1.height:=768;
                 end;
        3: begin glfullscreenviewer1.Width:=1154;
                 glfullscreenviewer1.height:=864;
                 end;
        4: begin glfullscreenviewer1.Width:=1280;
                 glfullscreenviewer1.height:=1024;
                 end;

        end;

        case form2.ComboBox7.ItemIndex of
        0: glfullscreenviewer1.screendepth:=sd8bits;
        1: glfullscreenviewer1.screendepth:=sd16bits;
        2: glfullscreenviewer1.screendepth:=sd24bits;
        3: glfullscreenviewer1.screendepth:=sd32bits;
        end;

        case form2.ComboBox6.itemindex of
        0: glfullscreenviewer1.Buffer.DepthPrecision:=dpdefault;
        1: glfullscreenviewer1.Buffer.DepthPrecision:=dp16bits;
        2: glfullscreenviewer1.Buffer.DepthPrecision:=dp24bits;
        3: glfullscreenviewer1.Buffer.DepthPrecision:=dp32bits;
        end;

        if form2.CheckBox21.Checked then glfullscreenviewer1.VSync:=vsmsync else glfullscreenviewer1.VSync:=vsmnosync;

        if form2.checkbox7.Checked then alphatest:=true else alphatest:=false;
log.wriln('alphatest');

        if typ=3 then begin minx:=-mi; maxz:=mj; log.wriln('minmax-1'); end else begin
                minx:=-30*mi;
                maxz:=30*mj;
                minx:=0;
                minz:=0;
                maxx:=3000;
                maxz:=3000;
        log.wriln('minmax-2');
        end;
        if form2.CheckBox3.Checked then miasto.rozmywanie:=true;
        if form2.CheckBox4.Checked then miasto.trawa:=true;
log.wriln('checkbox4');
        if Form2.CheckBox9.Checked then miasto.blending:=true;
log.wriln('checkbox9');
        if form2.checkbox6.Checked then
        begin
                glfullscreenviewer1.Buffer.Lighting:=true;
                glfullscreenviewer1.Buffer.Lighting:=true;
                glfullscreenviewer1.Buffer.Lighting:=true;
                log.wriln('checkbox6-1');
        end else
        begin
                glfullscreenviewer1.Buffer.Lighting:=false;
                glfullscreenviewer1.Buffer.Lighting:=false;
                glfullscreenviewer1.Buffer.Lighting:=false;

                log.wriln('checkbox6-2');
        end;
  //      if form2.CheckBox5.checked=false then begin
//                glsceneviewer2.Destroy;
//                glsceneviewer3.Destroy;
                lustrolewe.Destroy;
                lustroprawe.Destroy;
    //    end;
        log.wriln('mirrors');        
        gllightsource1.Position.x:=minx/2;
        gllightsource1.position.z:=maxz/2;


miasto.log:=log;
miasto.baza:=srsw;
miasto.swiatelka:=swiatelka;
miasto.szybki:=szybki;

miasto.init;
miasto.load(form2.plik);
miasto.loadsch(form2.sch);

timer1.Enabled:=true;
timer2.Enabled:=true;
nettimer.enabled:=true;
GLCadencer1.enabled:=true;

miasto.przystanek:=1;
log.wriln('03');
wysw_ster_text_4.text:=miasto.ttable[miasto.przystanek].nazwa+' ('+timetostr(miasto.ttable[miasto.przystanek].t)+')';
wysw_ster_text_3.text:=miasto.ttable[miasto.przystanek+1].nazwa;
log.wriln('01');

//ruch uliczny

if (not fileexists('map\'+copy(form2.plik,1,length(form2.plik)-4)+'.vt1')) or
   (not fileexists('map\'+copy(form2.plik,1,length(form2.plik)-4)+'.tr1')) then form2.trafik:=false;

   if form2.trafik then begin
traffic:=tpoje.create;
traffic.baza:=trbaza;
traffic.log:=log;
traffic.wczytaj(copy(form2.plik,1,length(form2.plik)-4));
end;

//obywatele;
 if form2.CheckBox19.Checked then begin
log.wri('obywatele ');
pasa:=tobywatele.create;
pasa.baza:=srsw;
pasa.log:=log;
pasa.init;
log.wriln('ok');
end;


//=====================load busa
//naped:=tnaped.create;
//naped.wczytajskrzynie('zf5hp500.gbx');
//naped.wczytajsilnik('su15.eng');

log.wriln('04');
log.wriln('05');

//plama_t.parent:=dummycube3;
//pmodel2:=unit2.Form2.pmodel;

for i:=1 to MAXBUS do begin

bus[i]:=tbusz.create;

bus[i].baza:=srsw;
bus[i].szybki:=szybki;
bus[i].log:=log;
bus[i].init;
bus[i].jestpulpit:=form2.checkbox18.Checked;

if form2.checkbox19.Checked then begin bus[i].ltyp:=pasa; bus[i].vpasa:=true; end else bus[i].vpasa:=false;
bus[i].posx:=miasto.p_sta[i].x;
bus[i].posy:=miasto.p_sta[i].y;
bus[i].dir:=miasto.p_sta[i].a;

bus[i].rozmywanie:=form2.checkbox3.checked;
bus[i].noc:=form2.checkbox9.checked;

//////////////////////////TBUSZ.WCZYTAJBUSA
bus[i].wczytajbusa(form2.pmodel,form2.ptekst);
//////////////////////////TBUSZ.WCZYTAJTEKSTURE
bus[i].wczytajteksture(form2.pmodel,form2.ptekst);
end;



log.wriln('mojnumer '+inttostr(mojnumer));
glcamera5.Parent:=bus[mojnumer].szyja;
if form2.CheckBox8.Checked then bus[mojnumer].strzala.Visible:=true;
if not form2.CheckBox8.Checked then hud_dist.Visible:=false;
glcamera5.Position.X:=0;
glcamera5.Position.y:=0;
glcamera5.Position.z:=0;
//log.wriln('a');
bus[mojnumer].naped.automat:=form2.CheckBox14.Checked;
bus[mojnumer].wychyl:=form2.TrackBar2.Position/20;
   bus[mojnumer].szyja.Up.X:=1;
   bus[mojnumer].szyja.Up.y:=0;
   bus[mojnumer].szyja.Up.z:=0;
   glcamera5.Up.X:=1;
   glcamera5.Up.y:=0;
   glcamera5.Up.z:=0;
    bus[mojnumer].szyja.roll(180);
//log.wriln('b');
    glcamera5.Pitch(70);
    cam_d_l.Parent:=bus[mojnumer].nadwozieA;
    cam_d_r.Parent:=bus[mojnumer].nadwozieA;
    cam_l_l.Parent:=bus[mojnumer].nadwozieA;
    cam_l_r.Parent:=bus[mojnumer].nadwozieA;
          {
if form2.checkbox5.Checked then begin
         lustrolewe.Parent:=bus[mojnumer].nadwozieA;
        lustroprawe.Parent:=bus[mojnumer].nadwozieA;
    lustroprawe.position.x:=+bus[mojnumer].koloP[2].bie.Position.y+0.7;
    lustroprawe.position.y:=bus[mojnumer].szyja.position.y;
    lustroprawe.position.z:=bus[mojnumer].szyja.position.z;
    lustrolewe.Position.x:=-bus[mojnumer].koloP[2].bie.Position.y-0.7;
    lustrolewe.position.y:=bus[mojnumer].szyja.position.y;
    lustrolewe.position.z:=bus[mojnumer].szyja.position.z;
        lustroprawe.PitchAngle:=-90;
        lustrolewe.PitchAngle:=-90;
        lustroprawe.rollAngle:=-90;
        lustrolewe.rollAngle:=-90;

        end;
          }
    cam_d_l.position:=bus[mojnumer].szyja.position;
    cam_d_r.Position:=bus[mojnumer].szyja.position;

    cam_l_r.position.x:=+bus[mojnumer].koloP[2].bie.Position.y+0.7;
    cam_l_r.position.y:=bus[mojnumer].szyja.position.y;
    cam_l_r.position.z:=bus[mojnumer].szyja.position.z;



    cam_l_l.Position.x:=-bus[mojnumer].koloP[2].bie.Position.y-0.7;
    cam_l_l.position.y:=bus[mojnumer].szyja.position.y;
    cam_l_l.position.z:=bus[mojnumer].szyja.position.z;



//log.wriln('c');
    cam_d_l.PitchAngle:=90;
    cam_d_r.PitchAngle:=90;
    cam_d_l.turnAngle:=90;
    cam_d_r.turnAngle:=-90;

    cam_l_r.PitchAngle:=90;
    cam_l_l.PitchAngle:=90;
    cam_l_r.turnAngle:=160;
    cam_l_l.turnAngle:=-160;



{
bus[mojnumer].naped.bieg:=1;
bus[mojnumer].naped.dziala:=true;}


glcamera1.Parent:=bus[mojnumer].dlakamery;
glcamera1.TargetObject:=bus[mojnumer].dlakamery;
glcamera1.position.y:=-2;


//log.wriln('d');
sams[1] := BASS_SampleLoad(FALSE, PChar('model\'+form2.pmodel+'\engine.wav'), 0, 0, 1, BASS_SAMPLE_OVER_POS+BASS_SAMPLE_LOOP);
sams[2] := BASS_SampleLoad(FALSE, PChar('model\'+form2.pmodel+'\dopen.wav'), 0, 0, 4, BASS_SAMPLE_OVER_POS);
sams[3] := BASS_SampleLoad(FALSE, PChar('model\'+form2.pmodel+'\dclose.wav'), 0, 0, 4, BASS_SAMPLE_OVER_POS);
sams[4] := BASS_SampleLoad(FALSE, PChar('model\'+form2.pmodel+'\kier.wav'), 0, 0, 1, BASS_SAMPLE_OVER_POS);
sams[5] := BASS_SampleLoad(FALSE, PChar('model\'+form2.pmodel+'\klakson.wav'), 0, 0, 1, BASS_SAMPLE_OVER_POS);
if fileexists('model\'+form2.pmodel+'\syg_kier.wav') then
sams[6] := BASS_SampleLoad(FALSE, PChar('model\'+form2.pmodel+'\syg_kier.wav'), 0, 0, 1, BASS_SAMPLE_OVER_POS)
else
sams[6] := BASS_SampleLoad(FALSE, PChar('model\'+form2.pmodel+'\kier.wav'), 0, 0, 1, BASS_SAMPLE_OVER_POS);
sams[7] := BASS_SampleLoad(FALSE, PChar('model\'+form2.pmodel+'\dzwonek.wav'), 0, 0, 1, BASS_SAMPLE_OVER_POS);

//log.wriln('e');
miasto.przystanek:=1;
    przystanek_liczba.Text:=inttostr(miasto.ttable[miasto.przystanek].osi);
    bus_liczba_2.Text:=inttostr(miasto.ttable[miasto.przystanek].oso);
    bus_liczba_1.Text:=inttostr(trunc(nop));

//log.wriln('f');

sh:=BASS_sampleplay(sams[1]);
BASS_ChannelPause(sh);
 mp3cur:=1;

if form2.CheckBox20.Checked then BASS_ChannelSetAttributes(sh,-1,0,-101);


for i:=0 to glmateriallibrary1.Materials.count-1 do
glmateriallibrary1.Materials[i].Material.texture.minfilter:=miNearest;

if not form2.CheckBox3.Checked then begin
  for i:=0 to glmateriallibrary1.Materials.count-1 do
   glmateriallibrary1.Materials[i].Material.texture.magfilter:=maNearest;
  for i:=0 to glmateriallibrary2.Materials.count-1 do begin
   glmateriallibrary2.Materials[i].Material.texture.minfilter:=miNearest;
   glmateriallibrary2.Materials[i].Material.texture.magfilter:=maNearest;
end;
  for i:=0 to glmateriallibrary3.Materials.count-1 do begin
   glmateriallibrary3.Materials[i].Material.texture.minfilter:=miNearest;
   glmateriallibrary3.Materials[i].Material.texture.magfilter:=maNearest;
  end;

  end;
//log.wriln('g');
if bus[mojnumer].liczbad<4 then dr_4.visible:=false;
if bus[mojnumer].liczbad<3 then dr_3.visible:=false;
if bus[mojnumer].liczbad<2 then dr_2.visible:=false;
//log.wriln('h');
if Form2.CheckBox9.Checked then begin
if not form2.CheckBox16.checked then begin
        glSkyDome1.Bands[0].StartColor.AsWinColor:=RGB(60, 60, 60);
        glSkyDome1.Bands[0].StopColor.AsWinColor:=RGB(0, 0, 0);
        glSkyDome1.Bands[1].StartColor.AsWinColor:=RGB(0, 0, 0);
        glSkyDome1.Bands[1].StopColor.AsWinColor:=RGB(0, 0, 0);
        glskyDome1.Stars.AddRandomStars(1000, clWhite, True);
end;
//log.wriln('i');
glfullscreenviewer1.Buffer.BackgroundColor:=RGB(0,16,0);
{if form2.CheckBox5.checked then begin
        glsceneviewer2.Buffer.BackgroundColor:=RGB(0,16,0);
        glsceneviewer3.Buffer.BackgroundColor:=RGB(0,16,0);
end;
 }
GLLightSource1.Ambient.AsWinColor:=RGB(0, 0, 0);
GLLightSource1.Diffuse.AsWinColor:=RGB(0, 0, 0);
GLLightSource1.Specular.AsWinColor:=RGB(0, 0, 0);

glmateriallibrary2.Materials[2].material.texture.imageBrightness:=0.2;
glmateriallibrary2.Materials[17].material.texture.imageBrightness:=0.2;
glmateriallibrary2.Materials[18].material.texture.imageBrightness:=0.2;
glmateriallibrary2.Materials[19].material.texture.imageBrightness:=0.2;




end;
 if miasto.trawa then begin
log.wri('trawa..');
trawa_1.Material:=miasto.matlib2.Materials[0].material;
log.wriln('ok');
end
else
trawa.Destroy;

if form2.CheckBox19.Checked then begin
if miasto.stops[miasto.ttable[miasto.przystanek].st].pro then
        begin
                pasa.przy.Position.x:=-miasto.stops[miasto.ttable[miasto.przystanek].st].px;
                pasa.przy.Position.z:=miasto.stops[miasto.ttable[miasto.przystanek].st].py;
                pasa.przy.turnangle:=miasto.stops[miasto.ttable[miasto.przystanek].st].pa;
                pasa.zalosujP(miasto.stops[miasto.ttable[miasto.przystanek].st].pw,
                        miasto.stops[miasto.ttable[miasto.przystanek].st].ph);

        end else
        begin
                pasa.przy.Position.x:=-miasto.stops[miasto.ttable[miasto.przystanek].st].x;
                pasa.przy.Position.z:=miasto.stops[miasto.ttable[miasto.przystanek].st].y;
                pasa.radius:=miasto.stops[miasto.ttable[miasto.przystanek].st].ang;
                pasa.zalosuj;

        end;

pasa.vis:=miasto.ttable[miasto.przystanek].osi;
//pasa.vis:=100;
pasa.pokaz;
end;
if not form2.checkbox17.Checked then begin
        hudtlo.Visible:=false;
        glhudsprite1.Visible:=false;
        dr_1.Visible:=false;
        dr_2.Visible:=false;
        dr_3.Visible:=false;
        dr_4.Visible:=false;
        sk1.Visible:=false;
        sk9.Visible:=false;
        podklad_napisy.Visible:=false;
        eng.Visible:=false;
        hud_ki.Visible:=false;
        hud_mi.Visible:=false;
        hud_przykl.Visible:=false;
        hud_bieg.Position.X:=20;
end;
  skaluj;
glfullscreenviewer1.Active:=true;

//form1.Hide;

log.wriln('formshow..ok');


end;






procedure TForm1.DirectOpenGL1Render(var rci: TRenderContextInfo);
begin
  if alphatest then begin
       glEnable(GL_ALPHA_TEST);
   glAlphaFunc(GL_GREATER,0.1);
   alphatest:=false;
   end;
//panel.Visible:=false;
end;


procedure TForm1.skaluj;
begin
   dr_1.Position.Y:=glfullscreenviewer1.Height-43;
   dr_2.Position.Y:=glfullscreenviewer1.Height-43;
   dr_3.Position.Y:=glfullscreenviewer1.Height-43;
   dr_4.Position.Y:=glfullscreenviewer1.Height-43;
   hud_ki.Position.Y:=glfullscreenviewer1.Height-43;
   hud_mi.Position.Y:=glfullscreenviewer1.Height-43;
   hud_bieg.Position.Y:=glfullscreenviewer1.Height-190;
   hud_przykl.Position.Y:=glfullscreenviewer1.Height-43;
   r_bieg.Position.Y:=glfullscreenviewer1.Height-43;
   eng.Position.y:=glfullscreenviewer1.Height-43;
   bus_text.Position.Y:=glfullscreenviewer1.Height-23;
   bus_liczba_1.Position.Y:=glfullscreenviewer1.Height-23;
   bus_liczba_2.Position.Y:=glfullscreenviewer1.Height-23;
   przystanek_text.Position.Y:=glfullscreenviewer1.Height-23;
   przystanek_liczba.Position.Y:=glfullscreenviewer1.Height-23;
   podklad_napisy.Position.Y:=glfullscreenviewer1.Height-13;
   glhudsprite1.Position.Y:=glfullscreenviewer1.Height-113;
   sk1.Position.Y:=glfullscreenviewer1.Height-101;
   sk9.Position.Y:=glfullscreenviewer1.Height-101;
   hudtlo.position.y:=glhudsprite1.position.y+30;
   hud_servermsg.position.y:=glfullscreenviewer1.height-20;

end;

procedure TForm1.Timer2Timer(Sender: TObject);
begin
miasto.sprawdz_sygn;
end;

procedure TForm1.Timer3Timer(Sender: TObject);
begin
wlacz_ster:=wlacz_ster+1;
end;

procedure TForm1.Timer4Timer(Sender: TObject);
begin
wylacz_ster:=wylacz_ster+1;
end;

procedure TForm1.nettimerTimer(Sender: TObject);
begin
if form2.connected then sendrecv;
end;

procedure TForm1.GLFullScreenViewer1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   mx:=x; my:=y;
end;

procedure TForm1.GLFullScreenViewer1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
 if Shift<>[] then begin
  if glfullscreenviewer1.Camera=glcamera1 then begin
      glCamera1.MoveAroundTarget(-my+y, -mx+x);
      mx:=x; my:=y;
      if Glcamera1.Position.y>-2 then glcamera1.position.y:=-2;
  end;
  if glfullscreenviewer1.Camera=glcamera5 then begin
      glcamera5.pitch((my-y)/5);
      bus[mojnumer].szyja.roll(-(mx-x)/5);
      my:=y;
      mx:=x;
   end;
 end;
end;

procedure TForm1.GLFullScreenViewer1MouseWheel(Sender: TObject;
  Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
begin
GLCamera1.AdjustDistanceToTarget(Power(1.1, WheelDelta/120));
 if Glcamera1.Position.y>-2 then glcamera1.position.y:=-2;
end;

procedure TForm1.GLFullScreenViewer1Close(Sender: TObject;
  var Action: TCloseAction);
begin
  form2.odlacz;
 glfullscreenviewer1.Active:=false;

 zamykaj;
end;

end.


